/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.book.BookEntryParent;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiComponent;

public class EntryConnectionRenderer {
    public int blitOffset;

    public void renderLinedUpEntries(PoseStack stack, BookEntry entry, BookEntry parentEntry, BookEntryParent parent, boolean isVertical) {
        if (isVertical) {
            this.drawVerticalLine(stack, parentEntry.getX(), entry.getY(), parentEntry.getY());
            if (parent.drawArrow()) {
                if (parentEntry.getY() > entry.getY()) {
                    this.drawUpArrow(stack, entry.getX(), entry.getY() + 1);
                } else {
                    this.drawDownArrow(stack, entry.getX(), entry.getY() - 1);
                }
            }
        } else {
            this.drawHorizontalLine(stack, parentEntry.getY(), entry.getX(), parentEntry.getX());
            if (parent.drawArrow()) {
                if (parentEntry.getX() > entry.getX()) {
                    this.drawLeftArrow(stack, entry.getX() + 1, entry.getY());
                } else {
                    this.drawRightArrow(stack, entry.getX() - 1, entry.getY());
                }
            }
        }
    }

    public void renderSmallCurves(PoseStack stack, BookEntry entry, BookEntry parentEntry, BookEntryParent parent) {
        this.drawVerticalLine(stack, entry.getX(), parentEntry.getY(), entry.getY());
        this.drawHorizontalLine(stack, parentEntry.getY(), parentEntry.getX(), entry.getX());
        if (entry.getX() > parentEntry.getX()) {
            if (entry.getY() > parentEntry.getY()) {
                this.drawSmallCurveLeftDown(stack, entry.getX(), parentEntry.getY());
                if (parent.drawArrow()) {
                    this.drawDownArrow(stack, entry.getX(), entry.getY() - 1);
                }
            } else {
                this.drawSmallCurveLeftUp(stack, entry.getX(), parentEntry.getY());
                if (parent.drawArrow()) {
                    this.drawUpArrow(stack, entry.getX(), entry.getY() + 1);
                }
            }
        } else if (entry.getY() > parentEntry.getY()) {
            this.drawSmallCurveRightDown(stack, entry.getX(), parentEntry.getY());
            if (parent.drawArrow()) {
                this.drawDownArrow(stack, entry.getX(), entry.getY() - 1);
            }
        } else {
            this.drawSmallCurveRightUp(stack, entry.getX(), parentEntry.getY());
            if (parent.drawArrow()) {
                this.drawUpArrow(stack, entry.getX(), entry.getY() + 1);
            }
        }
    }

    public void renderSmallCurvesReversed(PoseStack stack, BookEntry entry, BookEntry parentEntry, BookEntryParent parent) {
        this.drawHorizontalLine(stack, entry.getY(), entry.getX(), parentEntry.getX());
        this.drawVerticalLine(stack, parentEntry.getX(), parentEntry.getY(), entry.getY());
        if (entry.getX() > parentEntry.getX()) {
            if (entry.getY() > parentEntry.getY()) {
                this.drawSmallCurveRightUp(stack, parentEntry.getX(), entry.getY());
                if (parent.drawArrow()) {
                    this.drawRightArrow(stack, entry.getX() - 1, entry.getY());
                }
            } else {
                this.drawSmallCurveRightDown(stack, entry.getX() - 1, parentEntry.getY() - 1);
                if (parent.drawArrow()) {
                    this.drawRightArrow(stack, entry.getX() - 1, entry.getY());
                }
            }
        } else if (entry.getY() > parentEntry.getY()) {
            this.drawSmallCurveLeftUp(stack, entry.getX() + 1, entry.getY());
            if (parent.drawArrow()) {
                this.drawLeftArrow(stack, entry.getX() + 1, entry.getY());
            }
        } else {
            this.drawSmallCurveLeftDown(stack, entry.getX() + 1, parentEntry.getY() - 1);
            if (parent.drawArrow()) {
                this.drawLeftArrow(stack, entry.getX() + 1, entry.getY());
            }
        }
    }

    public void renderLargeCurves(PoseStack stack, BookEntry entry, BookEntry parentEntry, BookEntryParent parent) {
        this.drawHorizontalLineShortened(stack, parentEntry.getY(), parentEntry.getX(), entry.getX());
        this.drawVerticalLineShortened(stack, entry.getX(), entry.getY(), parentEntry.getY());
        if (entry.getX() > parentEntry.getX()) {
            if (entry.getY() > parentEntry.getY()) {
                this.drawLargeCurveLeftDown(stack, entry.getX() - 1, parentEntry.getY());
                if (parent.drawArrow()) {
                    this.drawDownArrow(stack, entry.getX(), entry.getY() - 1);
                }
            } else {
                this.drawLargeCurveLeftUp(stack, entry.getX() - 1, parentEntry.getY() - 1);
                if (parent.drawArrow()) {
                    this.drawUpArrow(stack, entry.getX(), entry.getY() + 1);
                }
            }
        } else if (entry.getY() > parentEntry.getY()) {
            this.drawLargeCurveRightDown(stack, entry.getX(), parentEntry.getY());
            if (parent.drawArrow()) {
                this.drawDownArrow(stack, entry.getX(), entry.getY() - 1);
            }
        } else {
            this.drawLargeCurveRightUp(stack, entry.getX(), parentEntry.getY() - 1);
            if (parent.drawArrow()) {
                this.drawUpArrow(stack, entry.getX(), entry.getY() + 1);
            }
        }
    }

    public void renderLargeCurvesReversed(PoseStack stack, BookEntry entry, BookEntry parentEntry, BookEntryParent parent) {
        this.drawHorizontalLineShortened(stack, entry.getY(), entry.getX(), parentEntry.getX());
        this.drawVerticalLineShortened(stack, parentEntry.getX(), parentEntry.getY(), entry.getY());
        if (entry.getX() > parentEntry.getX()) {
            if (entry.getY() > parentEntry.getY()) {
                this.drawLargeCurveRightUp(stack, parentEntry.getX(), entry.getY() - 1);
            } else {
                this.drawLargeCurveRightDown(stack, parentEntry.getX(), entry.getY());
            }
            if (parent.drawArrow()) {
                this.drawRightArrow(stack, entry.getX() - 1, entry.getY());
            }
        } else {
            if (entry.getY() > parentEntry.getY()) {
                this.drawLargeCurveLeftUp(stack, entry.getX() + 1, entry.getY() - 1);
            } else {
                this.drawLargeCurveLeftDown(stack, entry.getX() + 1, entry.getY());
            }
            if (parent.drawArrow()) {
                this.drawLeftArrow(stack, entry.getX() + 1, entry.getY());
            }
        }
    }

    public void render(PoseStack stack, BookEntry entry, BookEntryParent parent) {
        BookEntry parentEntry = parent.getEntry();
        if (parent.isLineEnabled() && parentEntry.getCategory().equals(entry.getCategory())) {
            int deltaX = Math.abs(entry.getX() - parentEntry.getX());
            int deltaY = Math.abs(entry.getY() - parentEntry.getY());
            if (deltaX == 0 || deltaY == 0) {
                this.renderLinedUpEntries(stack, entry, parentEntry, parent, deltaX == 0);
            } else if (deltaX < 2 || deltaY < 2) {
                if (!parent.isLineReversed()) {
                    this.renderSmallCurves(stack, entry, parentEntry, parent);
                } else {
                    this.renderSmallCurvesReversed(stack, entry, parentEntry, parent);
                }
            } else if (!parent.isLineReversed()) {
                this.renderLargeCurves(stack, entry, parentEntry, parent);
            } else {
                this.renderLargeCurvesReversed(stack, entry, parentEntry, parent);
            }
        }
    }

    protected void setBlitOffset(int blitOffset) {
        this.blitOffset = blitOffset;
    }

    protected int screenX(int x) {
        return x * 30;
    }

    protected int screenY(int y) {
        return y * 30;
    }

    protected void blit(PoseStack stack, int pX, int pY, float pUOffset, float pVOffset, int pUWidth, int pVHeight) {
        GuiComponent.m_93143_((PoseStack)stack, (int)pX, (int)pY, (int)this.blitOffset, (float)pUOffset, (float)pVOffset, (int)pUWidth, (int)pVHeight, (int)256, (int)256);
    }

    protected void drawSmallCurveLeftDown(PoseStack stack, int x, int y) {
        this.blit(stack, this.screenX(x), this.screenY(y), 0.0f, 226.0f, 30, 30);
    }

    protected void drawSmallCurveRightDown(PoseStack stack, int x, int y) {
        this.blit(stack, this.screenX(x), this.screenY(y), 30.0f, 226.0f, 30, 30);
    }

    protected void drawSmallCurveLeftUp(PoseStack stack, int x, int y) {
        this.blit(stack, this.screenX(x), this.screenY(y), 0.0f, 196.0f, 30, 30);
    }

    protected void drawSmallCurveRightUp(PoseStack stack, int x, int y) {
        this.blit(stack, this.screenX(x), this.screenY(y), 30.0f, 196.0f, 30, 30);
    }

    protected void drawLargeCurveLeftDown(PoseStack stack, int x, int y) {
        this.blit(stack, this.screenX(x), this.screenY(y), 62.0f, 196.0f, 60, 60);
    }

    protected void drawLargeCurveRightDown(PoseStack stack, int x, int y) {
        this.blit(stack, this.screenX(x), this.screenY(y), 122.0f, 196.0f, 60, 60);
    }

    protected void drawLargeCurveLeftUp(PoseStack stack, int x, int y) {
        this.blit(stack, this.screenX(x), this.screenY(y), 62.0f, 134.0f, 60, 60);
    }

    protected void drawLargeCurveRightUp(PoseStack stack, int x, int y) {
        this.blit(stack, this.screenX(x), this.screenY(y), 122.0f, 134.0f, 60, 60);
    }

    void drawVerticalLineAt(PoseStack stack, int x, int y) {
        this.blit(stack, this.screenX(x), this.screenY(y), 184.0f, 164.0f, 30, 31);
    }

    void drawHorizontalLineAt(PoseStack stack, int x, int y) {
        this.blit(stack, this.screenX(x), this.screenY(y), 184.0f, 226.0f, 31, 30);
    }

    void drawVerticalLine(PoseStack stack, int x, int startY, int endY) {
        int temp = startY;
        startY = Math.min(startY, endY);
        endY = Math.max(endY, temp);
        for (int j = startY + 1; j < endY; ++j) {
            this.drawVerticalLineAt(stack, x, j);
        }
    }

    void drawHorizontalLine(PoseStack stack, int y, int startX, int endX) {
        int temp = startX;
        startX = Math.min(startX, endX);
        endX = Math.max(endX, temp);
        for (int j = startX + 1; j < endX; ++j) {
            this.drawHorizontalLineAt(stack, j, y);
        }
    }

    void drawHorizontalLineShortened(PoseStack stack, int y, int startX, int endX) {
        int temp = startX;
        endX = startX > endX ? ++endX : --endX;
        startX = Math.min(startX, endX);
        endX = Math.max(endX, temp);
        for (int j = startX + 1; j < endX; ++j) {
            this.drawHorizontalLineAt(stack, j, y);
        }
    }

    void drawVerticalLineShortened(PoseStack stack, int x, int startY, int endY) {
        int temp = startY;
        endY = startY > endY ? ++endY : --endY;
        startY = Math.min(startY, endY);
        endY = Math.max(endY, temp);
        for (int j = startY + 1; j < endY; ++j) {
            this.drawVerticalLineAt(stack, x, j);
        }
    }

    void drawUpArrow(PoseStack stack, int x, int y) {
        this.blit(stack, this.screenX(x), this.screenY(y) - 1, 0.0f, 134.0f, 30, 30);
    }

    void drawDownArrow(PoseStack stack, int x, int y) {
        this.blit(stack, this.screenX(x), this.screenY(y) + 1, 0.0f, 164.0f, 30, 30);
    }

    void drawRightArrow(PoseStack stack, int x, int y) {
        this.blit(stack, this.screenX(x) + 1, this.screenY(y), 30.0f, 134.0f, 30, 30);
    }

    void drawLeftArrow(PoseStack stack, int x, int y) {
        this.blit(stack, this.screenX(x) - 1, this.screenY(y), 30.0f, 164.0f, 30, 30);
    }
}

