/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.relocated.commonmark.internal.inline;

import com.klikli_dev.relocated.commonmark.internal.inline.InlineContentParser;
import com.klikli_dev.relocated.commonmark.internal.inline.InlineParserState;
import com.klikli_dev.relocated.commonmark.internal.inline.ParsedInline;
import com.klikli_dev.relocated.commonmark.internal.inline.Position;
import com.klikli_dev.relocated.commonmark.internal.inline.Scanner;
import com.klikli_dev.relocated.commonmark.internal.util.Parsing;
import com.klikli_dev.relocated.commonmark.node.Code;
import com.klikli_dev.relocated.commonmark.node.Text;
import com.klikli_dev.relocated.commonmark.parser.SourceLines;

public class BackticksInlineParser
implements InlineContentParser {
    @Override
    public ParsedInline tryParse(InlineParserState inlineParserState) {
        Scanner scanner = inlineParserState.scanner();
        Position start = scanner.position();
        int openingTicks = scanner.matchMultiple('`');
        Position afterOpening = scanner.position();
        while (scanner.find('`') > 0) {
            Position beforeClosing = scanner.position();
            int count = scanner.matchMultiple('`');
            if (count != openingTicks) continue;
            Code node = new Code();
            String content = scanner.getSource(afterOpening, beforeClosing).getContent();
            if ((content = content.replace('\n', ' ')).length() >= 3 && content.charAt(0) == ' ' && content.charAt(content.length() - 1) == ' ' && Parsing.hasNonSpace(content)) {
                content = content.substring(1, content.length() - 1);
            }
            node.setLiteral(content);
            return ParsedInline.of(node, scanner.position());
        }
        SourceLines source = scanner.getSource(start, afterOpening);
        Text text = new Text(source.getContent());
        return ParsedInline.of(text, afterOpening);
    }
}

