/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.progress;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.function.BooleanSupplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.progress.IProgressInfoHandler;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.jei.MekanismJEIRecipeType;
import mekanism.client.jei.interfaces.IJEIRecipeArea;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.inventory.warning.ISupportsWarning;
import mekanism.common.inventory.warning.WarningTracker;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiProgress
extends GuiTexturedElement
implements IJEIRecipeArea<GuiProgress>,
ISupportsWarning<GuiProgress> {
    protected final IProgressInfoHandler handler;
    protected final ProgressType type;
    private MekanismJEIRecipeType<?>[] recipeCategories;
    @Nullable
    private ColorDetails colorDetails;
    @Nullable
    private BooleanSupplier warningSupplier;

    public GuiProgress(IProgressInfoHandler.IBooleanProgressInfoHandler handler, ProgressType type, IGuiWrapper gui, int x, int y) {
        this((IProgressInfoHandler)handler, type, gui, x, y);
    }

    public GuiProgress(IProgressInfoHandler handler, ProgressType type, IGuiWrapper gui, int x, int y) {
        super(type.getTexture(), gui, x, y, type.getWidth(), type.getHeight());
        this.type = type;
        this.handler = handler;
    }

    public GuiProgress colored(ColorDetails colorDetails) {
        this.colorDetails = colorDetails;
        return this;
    }

    @Override
    public GuiProgress warning(@NotNull WarningTracker.WarningType type, @NotNull BooleanSupplier warningSupplier) {
        this.warningSupplier = ISupportsWarning.compound(this.warningSupplier, this.gui().trackWarning(type, warningSupplier));
        return this;
    }

    @Override
    public void drawBackground(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        if (this.handler.isActive()) {
            double progress;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getResource());
            GuiProgress.m_93133_((PoseStack)matrix, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)0.0f, (int)this.f_93618_, (int)this.f_93619_, (int)this.type.getTextureWidth(), (int)this.type.getTextureHeight());
            boolean warning = this.warningSupplier != null && this.warningSupplier.getAsBoolean();
            double d = progress = warning ? 1.0 : this.getProgress();
            if (this.type.isVertical()) {
                int displayInt = (int)(progress * (double)this.f_93619_);
                if (displayInt > 0) {
                    int innerOffsetY = 0;
                    if (this.type.isReverse()) {
                        innerOffsetY += this.type.getTextureHeight() - displayInt;
                    }
                    this.blit(matrix, this.f_93620_, this.f_93621_ + innerOffsetY, this.type.getOverlayX(warning), this.type.getOverlayY(warning) + innerOffsetY, this.f_93618_, displayInt, this.type.getTextureWidth(), this.type.getTextureHeight(), progress, warning);
                }
            } else {
                int innerOffsetX = this.type == ProgressType.BAR ? 1 : 0;
                int displayInt = (int)(progress * (double)(this.f_93618_ - 2 * innerOffsetX));
                if (displayInt > 0) {
                    if (this.type.isReverse()) {
                        innerOffsetX += this.type.getTextureWidth() - displayInt;
                    }
                    this.blit(matrix, this.f_93620_ + innerOffsetX, this.f_93621_, this.type.getOverlayX(warning) + innerOffsetX, this.type.getOverlayY(warning), displayInt, this.f_93619_, this.type.getTextureWidth(), this.type.getTextureHeight(), progress, warning);
                }
            }
        }
    }

    protected double getProgress() {
        return Math.min(this.handler.getProgress(), 1.0);
    }

    @Override
    public boolean isJEIAreaActive() {
        return this.handler.isActive();
    }

    @Override
    @NotNull
    public GuiProgress jeiCategories(MekanismJEIRecipeType<?> ... recipeCategories) {
        this.recipeCategories = recipeCategories;
        return this;
    }

    @Override
    @Nullable
    public MekanismJEIRecipeType<?>[] getRecipeCategories() {
        return this.recipeCategories;
    }

    private void blit(PoseStack matrixStack, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight, double progress, boolean warning) {
        if (warning || this.colorDetails == null) {
            GuiProgress.m_93133_((PoseStack)matrixStack, (int)x, (int)y, (float)uOffset, (float)vOffset, (int)width, (int)height, (int)textureWidth, (int)textureHeight);
            return;
        }
        int colorFrom = this.colorDetails.getColorFrom();
        int colorTo = this.colorDetails.getColorTo();
        if (colorFrom == -1 && colorTo == -1) {
            GuiProgress.m_93133_((PoseStack)matrixStack, (int)x, (int)y, (float)uOffset, (float)vOffset, (int)width, (int)height, (int)textureWidth, (int)textureHeight);
            return;
        }
        int x2 = x + width;
        int y2 = y + height;
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        float minU = uOffset / (float)textureWidth;
        float maxU = (uOffset + (float)width) / (float)textureWidth;
        float minV = vOffset / (float)textureHeight;
        float maxV = (vOffset + (float)height) / (float)textureHeight;
        float alphaFrom = MekanismRenderer.getAlpha(colorFrom);
        float redFrom = MekanismRenderer.getRed(colorFrom);
        float greenFrom = MekanismRenderer.getGreen(colorFrom);
        float blueFrom = MekanismRenderer.getBlue(colorFrom);
        float alphaTo = MekanismRenderer.getAlpha(colorTo);
        float redTo = MekanismRenderer.getRed(colorTo);
        float greenTo = MekanismRenderer.getGreen(colorTo);
        float blueTo = MekanismRenderer.getBlue(colorTo);
        float percent = (float)progress;
        alphaTo = alphaFrom + percent * (alphaTo - alphaFrom);
        redTo = redFrom + percent * (redTo - redFrom);
        greenTo = greenFrom + percent * (greenTo - greenFrom);
        blueTo = blueFrom + percent * (blueTo - blueFrom);
        if (this.type.isReverse()) {
            float alphaTemp = alphaTo;
            float redTemp = redTo;
            float greenTemp = greenTo;
            float blueTemp = blueTo;
            alphaTo = alphaFrom;
            redTo = redFrom;
            greenTo = greenFrom;
            blueTo = blueFrom;
            alphaFrom = alphaTemp;
            redFrom = redTemp;
            greenFrom = greenTemp;
            blueFrom = blueTemp;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        if (this.type.isVertical()) {
            builder.m_85982_(matrix, (float)x, (float)y2, 0.0f).m_85950_(redTo, greenTo, blueTo, alphaTo).m_7421_(minU, maxV).m_5752_();
            builder.m_85982_(matrix, (float)x2, (float)y2, 0.0f).m_85950_(redTo, greenTo, blueTo, alphaTo).m_7421_(maxU, maxV).m_5752_();
            builder.m_85982_(matrix, (float)x2, (float)y, 0.0f).m_85950_(redFrom, greenFrom, blueFrom, alphaFrom).m_7421_(maxU, minV).m_5752_();
            builder.m_85982_(matrix, (float)x, (float)y, 0.0f).m_85950_(redFrom, greenFrom, blueFrom, alphaFrom).m_7421_(minU, minV).m_5752_();
        } else {
            builder.m_85982_(matrix, (float)x, (float)y2, 0.0f).m_85950_(redFrom, greenFrom, blueFrom, alphaFrom).m_7421_(minU, maxV).m_5752_();
            builder.m_85982_(matrix, (float)x2, (float)y2, 0.0f).m_85950_(redTo, greenTo, blueTo, alphaTo).m_7421_(maxU, maxV).m_5752_();
            builder.m_85982_(matrix, (float)x2, (float)y, 0.0f).m_85950_(redTo, greenTo, blueTo, alphaTo).m_7421_(maxU, minV).m_5752_();
            builder.m_85982_(matrix, (float)x, (float)y, 0.0f).m_85950_(redFrom, greenFrom, blueFrom, alphaFrom).m_7421_(minU, minV).m_5752_();
        }
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        MekanismRenderer.resetColor();
    }

    public static interface ColorDetails {
        public int getColorFrom();

        public int getColorTo();
    }
}

