/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.api.math.MathUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTexturedElement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public abstract class GuiScrollableElement
extends GuiTexturedElement {
    protected double scroll;
    private boolean isDragging;
    private int dragOffset;
    protected final int maxBarHeight;
    protected final int barWidth;
    protected final int barHeight;
    protected final int barXShift;
    protected int barX;
    protected int barY;

    protected GuiScrollableElement(ResourceLocation resource, IGuiWrapper gui, int x, int y, int width, int height, int barXShift, int barYShift, int barWidth, int barHeight, int maxBarHeight) {
        super(resource, gui, x, y, width, height);
        this.barXShift = barXShift;
        this.barX = this.f_93620_ + barXShift;
        this.barY = this.f_93621_ + barYShift;
        this.barWidth = barWidth;
        this.barHeight = barHeight;
        this.maxBarHeight = maxBarHeight;
    }

    @Override
    public void resize(int prevLeft, int prevTop, int left, int top) {
        super.resize(prevLeft, prevTop, left, top);
        this.barX = this.barX - prevLeft + left;
        this.barY = this.barY - prevTop + top;
    }

    @Override
    public void move(int changeX, int changeY) {
        super.move(changeX, changeY);
        this.barX += changeX;
        this.barY += changeY;
    }

    protected abstract int getMaxElements();

    protected abstract int getFocusedElements();

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        int scroll = this.getScroll();
        if (mouseX >= (double)this.barX && mouseX <= (double)(this.barX + this.barWidth) && mouseY >= (double)(this.barY + scroll) && mouseY <= (double)(this.barY + scroll + this.barHeight)) {
            if (this.needsScrollBars()) {
                double yAxis = mouseY - (double)this.getGuiTop();
                this.dragOffset = (int)(yAxis - (double)(scroll + this.barY));
                this.isDragging = true;
            } else {
                this.scroll = 0.0;
            }
        }
    }

    @Override
    public void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
        super.m_7212_(mouseX, mouseY, deltaX, deltaY);
        if (this.isDragging && this.needsScrollBars()) {
            double yAxis = mouseY - (double)this.getGuiTop();
            this.scroll = Mth.m_14008_((double)((yAxis - (double)this.barY - (double)this.dragOffset) / (double)this.getMax()), (double)0.0, (double)1.0);
        }
    }

    @Override
    public void m_7691_(double mouseX, double mouseY) {
        super.m_7691_(mouseX, mouseY);
        this.dragOffset = 0;
        this.isDragging = false;
    }

    protected boolean needsScrollBars() {
        return this.getMaxElements() > this.getFocusedElements();
    }

    protected final int getElements() {
        return this.getMaxElements() - this.getFocusedElements();
    }

    protected int getScrollElementScaler() {
        return 1;
    }

    private int getMax() {
        return this.maxBarHeight - this.barHeight;
    }

    protected int getScroll() {
        int max = this.getMax();
        return Mth.m_14045_((int)((int)(this.scroll * (double)max)), (int)0, (int)max);
    }

    public int getCurrentSelection() {
        return this.needsScrollBars() ? (int)(((double)this.getElements() + 0.5) * this.scroll) : 0;
    }

    public boolean adjustScroll(double delta) {
        int elements;
        if (delta != 0.0 && this.needsScrollBars() && (elements = MathUtils.clampToInt(Math.ceil((double)this.getElements() / (double)this.getScrollElementScaler()))) > 0) {
            delta = delta > 0.0 ? 1.0 : -1.0;
            this.scroll = (float)Mth.m_14008_((double)(this.scroll - delta / (double)elements), (double)0.0, (double)1.0);
            return true;
        }
        return false;
    }

    protected void drawScrollBar(PoseStack matrix, int textureWidth, int textureHeight) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getResource());
        GuiScrollableElement.m_93133_((PoseStack)matrix, (int)(this.barX - 1), (int)(this.barY - 1), (float)0.0f, (float)0.0f, (int)textureWidth, (int)1, (int)textureWidth, (int)textureHeight);
        GuiScrollableElement.m_93160_((PoseStack)matrix, (int)(this.barX - 1), (int)this.barY, (int)6, (int)this.maxBarHeight, (float)0.0f, (float)1.0f, (int)textureWidth, (int)1, (int)textureWidth, (int)textureHeight);
        GuiScrollableElement.m_93133_((PoseStack)matrix, (int)(this.barX - 1), (int)(this.f_93621_ + this.maxBarHeight + 2), (float)0.0f, (float)0.0f, (int)textureWidth, (int)1, (int)textureWidth, (int)textureHeight);
        GuiScrollableElement.m_93133_((PoseStack)matrix, (int)this.barX, (int)(this.barY + this.getScroll()), (float)0.0f, (float)2.0f, (int)this.barWidth, (int)this.barHeight, (int)textureWidth, (int)textureHeight);
    }

    @Override
    public boolean hasPersistentData() {
        return true;
    }

    @Override
    public void syncFrom(GuiElement element) {
        super.syncFrom(element);
        GuiScrollableElement old = (GuiScrollableElement)element;
        if (this.needsScrollBars() && old.needsScrollBars()) {
            this.scroll = old.scroll;
        }
    }
}

