/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import mekanism.client.model.ModelPartData;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class MekanismJavaModel
extends Model {
    public MekanismJavaModel(Function<ResourceLocation, RenderType> renderType) {
        super(renderType);
    }

    protected static VertexConsumer getVertexConsumer(@NotNull MultiBufferSource renderer, @NotNull RenderType renderType, boolean hasEffect) {
        return ItemRenderer.m_115222_((MultiBufferSource)renderer, (RenderType)renderType, (boolean)false, (boolean)hasEffect);
    }

    protected static void setRotation(ModelPart model, float x, float y, float z) {
        model.f_104203_ = x;
        model.f_104204_ = y;
        model.f_104205_ = z;
    }

    protected static void renderPartsToBuffer(List<ModelPart> parts, PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int light, int overlayLight, float red, float green, float blue, float alpha) {
        for (ModelPart part : parts) {
            part.m_104306_(poseStack, vertexConsumer, light, overlayLight, red, green, blue, alpha);
        }
    }

    protected static List<ModelPart> getRenderableParts(ModelPart root, ModelPartData ... modelPartData) {
        ArrayList<ModelPart> parts = new ArrayList<ModelPart>(modelPartData.length);
        for (ModelPartData partData : modelPartData) {
            parts.add(partData.getFromRoot(root));
        }
        return parts;
    }

    protected static LayerDefinition createLayerDefinition(int textureWidth, int textureHeight, ModelPartData ... parts) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        for (ModelPartData part : parts) {
            part.addToDefinition(partdefinition);
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)textureWidth, (int)textureHeight);
    }

    protected static void renderPartsAsWireFrame(List<ModelPart> parts, PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int red, int green, int blue, int alpha) {
        for (ModelPart part : parts) {
            MekanismJavaModel.renderWireFrame(part, poseStack, vertexConsumer, red, green, blue, alpha);
        }
    }

    public static void renderWireFrame(ModelPart part, PoseStack matrix, VertexConsumer vertexConsumer, int red, int green, int blue, int alpha) {
        if (part.f_104207_) {
            part.m_171309_(matrix, (pose, name, cubeIndex, cube) -> {
                Matrix4f matrix4f = pose.m_85861_();
                for (ModelPart.Polygon quad : cube.f_104341_) {
                    Vector3f normal = quad.f_104360_.m_122281_();
                    normal.m_122249_(pose.m_85864_());
                    float normalX = normal.m_122239_();
                    float normalY = normal.m_122260_();
                    float normalZ = normal.m_122269_();
                    Vector4f vertex = MekanismJavaModel.getVertex(matrix4f, quad.f_104359_[0]);
                    Vector4f vertex2 = MekanismJavaModel.getVertex(matrix4f, quad.f_104359_[1]);
                    Vector4f vertex3 = MekanismJavaModel.getVertex(matrix4f, quad.f_104359_[2]);
                    Vector4f vertex4 = MekanismJavaModel.getVertex(matrix4f, quad.f_104359_[3]);
                    vertexConsumer.m_5483_((double)vertex.m_123601_(), (double)vertex.m_123615_(), (double)vertex.m_123616_()).m_6122_(red, green, blue, alpha).m_5601_(normalX, normalY, normalZ).m_5752_();
                    vertexConsumer.m_5483_((double)vertex2.m_123601_(), (double)vertex2.m_123615_(), (double)vertex2.m_123616_()).m_6122_(red, green, blue, alpha).m_5601_(normalX, normalY, normalZ).m_5752_();
                    vertexConsumer.m_5483_((double)vertex3.m_123601_(), (double)vertex3.m_123615_(), (double)vertex3.m_123616_()).m_6122_(red, green, blue, alpha).m_5601_(normalX, normalY, normalZ).m_5752_();
                    vertexConsumer.m_5483_((double)vertex4.m_123601_(), (double)vertex4.m_123615_(), (double)vertex4.m_123616_()).m_6122_(red, green, blue, alpha).m_5601_(normalX, normalY, normalZ).m_5752_();
                    vertexConsumer.m_5483_((double)vertex2.m_123601_(), (double)vertex2.m_123615_(), (double)vertex2.m_123616_()).m_6122_(red, green, blue, alpha).m_5601_(normalX, normalY, normalZ).m_5752_();
                    vertexConsumer.m_5483_((double)vertex3.m_123601_(), (double)vertex3.m_123615_(), (double)vertex3.m_123616_()).m_6122_(red, green, blue, alpha).m_5601_(normalX, normalY, normalZ).m_5752_();
                    vertexConsumer.m_5483_((double)vertex.m_123601_(), (double)vertex.m_123615_(), (double)vertex.m_123616_()).m_6122_(red, green, blue, alpha).m_5601_(normalX, normalY, normalZ).m_5752_();
                    vertexConsumer.m_5483_((double)vertex4.m_123601_(), (double)vertex4.m_123615_(), (double)vertex4.m_123616_()).m_6122_(red, green, blue, alpha).m_5601_(normalX, normalY, normalZ).m_5752_();
                }
            });
        }
    }

    private static Vector4f getVertex(Matrix4f matrix4f, ModelPart.Vertex vertex) {
        Vector4f vector4f = new Vector4f(vertex.f_104371_.m_122239_() / 16.0f, vertex.f_104371_.m_122260_() / 16.0f, vertex.f_104371_.m_122269_() / 16.0f, 1.0f);
        vector4f.m_123607_(matrix4f);
        return vector4f;
    }
}

