/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import mekanism.common.content.gear.mekatool.ModuleVeinMiningUnit;
import mekanism.common.util.MultipartUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public interface IBlastingItem {
    public Map<BlockPos, BlockState> getBlastedBlocks(Level var1, Player var2, ItemStack var3, BlockPos var4, BlockState var5);

    public static Map<BlockPos, BlockState> findPositions(Level world, BlockPos targetPos, Player player, int radius) {
        Direction targetSide;
        if (radius > 0 && (targetSide = IBlastingItem.getTargetSide(world, targetPos, player)) != null) {
            Vec3i lower;
            Vec3i upper = switch (targetSide) {
                case Direction.UP, Direction.DOWN -> {
                    lower = new Vec3i(-radius, 0, -radius);
                    yield new Vec3i(radius, 0, radius);
                }
                case Direction.EAST, Direction.WEST -> {
                    lower = new Vec3i(0, -1, -radius);
                    yield new Vec3i(0, 2 * radius - 1, radius);
                }
                case Direction.NORTH, Direction.SOUTH -> {
                    lower = new Vec3i(-radius, -1, 0);
                    yield new Vec3i(radius, 2 * radius - 1, 0);
                }
                default -> {
                    lower = new Vec3i(0, 0, 0);
                    yield new Vec3i(0, 0, 0);
                }
            };
            HashMap<BlockPos, BlockState> found = new HashMap<BlockPos, BlockState>();
            for (BlockPos nextPos : BlockPos.m_121940_((BlockPos)targetPos.m_121955_(lower), (BlockPos)targetPos.m_121955_(upper))) {
                BlockState nextState;
                if (!IBlastingItem.canBlastBlock(world, nextPos, nextState = world.m_8055_(nextPos))) continue;
                found.put(nextPos.m_7949_(), nextState);
            }
            return found;
        }
        return Collections.emptyMap();
    }

    @Nullable
    private static Direction getTargetSide(Level world, BlockPos targetPos, Player player) {
        MultipartUtils.RayTraceVectors rayTraceVectors = MultipartUtils.getRayTraceVectors((Entity)player);
        Vec3 start = rayTraceVectors.start();
        Vec3 end = rayTraceVectors.end();
        Vec3 distance = end.m_82546_(start);
        if (distance.m_82556_() < 1.0E-7) {
            return null;
        }
        BlockState targetState = world.m_8055_(targetPos);
        VoxelShape shape = targetState.m_60651_((BlockGetter)world, targetPos, CollisionContext.m_82750_((Entity)player));
        if (!shape.m_83281_()) {
            AABB bounds = shape.m_83215_();
            double[] ignoredMinDistance = new double[]{1.0};
            return AABB.m_82325_((AABB)bounds.m_82338_(targetPos), (Vec3)start, (double[])ignoredMinDistance, null, (double)(end.f_82479_ - start.f_82479_), (double)(end.f_82480_ - start.f_82480_), (double)(end.f_82481_ - start.f_82481_));
        }
        return null;
    }

    public static boolean canBlastBlock(Level world, BlockPos pos, BlockState state) {
        return !state.m_60795_() && !state.m_60767_().m_76332_() && ModuleVeinMiningUnit.canVeinBlock(state) && state.m_60800_((BlockGetter)world, pos) > 0.0f;
    }
}

