/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class ItemElectricBow
extends BowItem
implements IModeItem,
IItemHUDProvider {
    public ItemElectricBow(Item.Properties properties) {
        super(properties.m_41497_(Rarity.RARE).setNoRepair().m_41487_(1));
    }

    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        StorageUtils.addStoredEnergy(stack, tooltip, true);
        tooltip.add((Component)MekanismLang.FIRE_MODE.translateColored(EnumColor.PINK, BooleanStateDisplay.OnOff.of(this.getFireState(stack))));
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            IEnergyContainer energyContainer = null;
            boolean fireState = this.getFireState(stack);
            if (!player.m_7500_()) {
                FloatingLong energyNeeded;
                energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                FloatingLong floatingLong = energyNeeded = fireState ? (FloatingLong)MekanismConfig.gear.electricBowEnergyUsageFire.get() : (FloatingLong)MekanismConfig.gear.electricBowEnergyUsage.get();
                if (energyContainer == null || energyContainer.extract(energyNeeded, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyNeeded)) {
                    return;
                }
            }
            boolean infinity = player.m_7500_() || stack.getEnchantmentLevel(Enchantments.f_44952_) > 0;
            ItemStack ammo = player.m_6298_(stack);
            int charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)world, (Player)player, (int)(this.m_8105_(stack) - timeLeft), (!ammo.m_41619_() || infinity ? 1 : 0) != 0);
            if (charge < 0) {
                return;
            }
            if (!ammo.m_41619_() || infinity) {
                ArrowItem arrow;
                Item item;
                boolean noConsume;
                float velocity = ItemElectricBow.m_40661_((int)charge);
                if ((double)velocity < 0.1) {
                    return;
                }
                if (ammo.m_41619_()) {
                    ammo = new ItemStack((ItemLike)Items.f_42412_);
                }
                boolean bl = noConsume = player.m_7500_() || (item = ammo.m_41720_()) instanceof ArrowItem && (arrow = (ArrowItem)item).isInfinite(ammo, stack, player);
                if (!world.f_46443_) {
                    int punch;
                    int power;
                    ArrowItem arrowitem = (ArrowItem)(ammo.m_41720_() instanceof ArrowItem ? ammo.m_41720_() : Items.f_42412_);
                    AbstractArrow arrowEntity = arrowitem.m_6394_(world, ammo, (LivingEntity)player);
                    arrowEntity = this.customArrow(arrowEntity);
                    arrowEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f * velocity, 1.0f);
                    if (velocity == 1.0f) {
                        arrowEntity.m_36762_(true);
                    }
                    if ((power = stack.getEnchantmentLevel(Enchantments.f_44988_)) > 0) {
                        arrowEntity.m_36781_(arrowEntity.m_36789_() + 0.5 * (double)power + 0.5);
                    }
                    if ((punch = stack.getEnchantmentLevel(Enchantments.f_44989_)) > 0) {
                        arrowEntity.m_36735_(punch);
                    }
                    if (fireState || stack.getEnchantmentLevel(Enchantments.f_44990_) > 0) {
                        arrowEntity.m_20254_(100);
                    }
                    if (!player.m_7500_() && energyContainer != null) {
                        energyContainer.extract(fireState ? (FloatingLong)MekanismConfig.gear.electricBowEnergyUsageFire.get() : (FloatingLong)MekanismConfig.gear.electricBowEnergyUsage.get(), Action.EXECUTE, AutomationType.MANUAL);
                    }
                    if (noConsume || player.m_7500_() && (ammo.m_41720_() == Items.f_42737_ || ammo.m_41720_() == Items.f_42738_)) {
                        arrowEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    world.m_7967_((Entity)arrowEntity);
                }
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (world.f_46441_.m_188501_() * 0.4f + 1.2f) + velocity * 0.5f);
                if (!noConsume && !player.m_7500_()) {
                    ammo.m_41774_(1);
                    if (ammo.m_41619_()) {
                        player.m_150109_().m_36057_(ammo);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public void setFireState(ItemStack stack, boolean state) {
        ItemDataUtils.setBoolean(stack, "mode", state);
    }

    public boolean getFireState(ItemStack stack) {
        return ItemDataUtils.getBoolean(stack, "mode");
    }

    @Override
    public void addHUDStrings(List<Component> list, Player player, ItemStack stack, EquipmentSlot slotType) {
        list.add((Component)MekanismLang.FIRE_MODE.translateColored(EnumColor.PINK, BooleanStateDisplay.OnOff.of(this.getFireState(stack))));
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return true;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return StorageUtils.getEnergyBarWidth(stack);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return MekanismConfig.client.energyColor.get();
    }

    public void m_6787_(@NotNull CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
        super.m_6787_(group, items);
        if (this.m_220152_(group)) {
            items.add((Object)StorageUtils.getFilledEnergyVariant(new ItemStack((ItemLike)this), MekanismConfig.gear.electricBowMaxEnergy));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        if (!MekanismConfig.gear.isLoaded()) {
            return super.initCapabilities(stack, nbt);
        }
        return new ItemCapabilityWrapper(stack, RateLimitEnergyHandler.create(MekanismConfig.gear.electricBowChargeRate, MekanismConfig.gear.electricBowMaxEnergy, BasicEnergyContainer.manualOnly, BasicEnergyContainer.alwaysTrue));
    }

    @Override
    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, boolean displayChangeMessage) {
        if (Math.abs(shift) % 2 == 1) {
            boolean newState = !this.getFireState(stack);
            this.setFireState(stack, newState);
            if (displayChangeMessage) {
                player.m_213846_(MekanismUtils.logFormat(MekanismLang.FIRE_MODE.translate(BooleanStateDisplay.OnOff.of(newState, true))));
            }
        }
    }

    @Override
    @NotNull
    public Component getScrollTextComponent(@NotNull ItemStack stack) {
        return MekanismLang.FIRE_MODE.translateColored(EnumColor.PINK, BooleanStateDisplay.OnOff.of(this.getFireState(stack), true));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }
}

