/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage;

import com.buuz135.industrial.block.IndustrialBlock;
import com.buuz135.industrial.block.transportstorage.tile.BlackHoleTankTile;
import com.buuz135.industrial.capability.BlockFluidHandlerItemStack;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.datagenerator.loot.block.BasicBlockLootTables;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.util.LangUtil;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.registries.RegistryObject;

public class BlackHoleTankBlock
extends IndustrialBlock<BlackHoleTankTile> {
    private Rarity rarity;

    public BlackHoleTankBlock(Rarity rarity) {
        super(rarity.name().toLowerCase() + "_black_hole_tank", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_), BlackHoleTankTile.class, (CreativeModeTab)ModuleTransportStorage.TAB_TRANSPORT);
        this.rarity = rarity;
    }

    public BlockEntityType.BlockEntitySupplier<BlackHoleTankTile> getTileEntityFactory() {
        return (p_155268_, p_155269_) -> new BlackHoleTankTile((BasicTileBlock<BlackHoleTankTile>)this, this.getRarityType(), this.rarity, p_155268_, p_155269_);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(iFluidHandlerItem -> {
            if (!iFluidHandlerItem.getFluidInTank(0).isEmpty()) {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + LangUtil.getString((String)"text.industrialforegoing.tooltip.contains", (Object[])new Object[0]) + ": " + ChatFormatting.WHITE + new DecimalFormat().format(iFluidHandlerItem.getFluidInTank(0).getAmount()) + ChatFormatting.YELLOW + LangUtil.getString((String)"tooltip.industrialforegoing.mb_of", (Object[])new Object[]{ChatFormatting.DARK_AQUA + iFluidHandlerItem.getFluidInTank(0).getDisplayName().getString()}))));
            }
        });
        tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + LangUtil.getString((String)"text.industrialforegoing.tooltip.can_hold", (Object[])new Object[0]) + ": " + ChatFormatting.WHITE + new DecimalFormat().format(BlockUtils.getFluidAmountByRarity(this.rarity)) + ChatFormatting.DARK_AQUA + LangUtil.getString((String)"text.industrialforegoing.tooltip.mb", (Object[])new Object[0]))));
    }

    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    public void m_6256_(BlockState state, Level worldIn, BlockPos pos, Player player) {
    }

    public LootTable.Builder getLootTable(@Nonnull BasicBlockLootTables blockLootTables) {
        CopyNbtFunction.Builder nbtBuilder = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_);
        nbtBuilder.m_80279_("tank", "BlockEntityTag.tank");
        nbtBuilder.m_80279_("filter", "BlockEntityTag.filter");
        return blockLootTables.droppingSelfWithNbt((ItemLike)this, nbtBuilder);
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        return NonNullList.m_122779_();
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        if (this.rarity == Rarity.COMMON) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).m_126130_("PPP").m_126130_("CEC").m_126130_("CMC").m_206416_(Character.valueOf('P'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('E'), IndustrialTags.Items.GEAR_IRON).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42446_).m_206416_(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_PITY).m_176498_(consumer);
        } else {
            TagKey<Item> tag = IndustrialTags.Items.MACHINE_FRAME_PITY;
            if (this.rarity == ModuleCore.SIMPLE_RARITY) {
                tag = IndustrialTags.Items.MACHINE_FRAME_SIMPLE;
            }
            if (this.rarity == ModuleCore.ADVANCED_RARITY) {
                tag = IndustrialTags.Items.MACHINE_FRAME_ADVANCED;
            }
            if (this.rarity == ModuleCore.SUPREME_RARITY) {
                tag = IndustrialTags.Items.MACHINE_FRAME_SUPREME;
            }
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).m_126130_("PPP").m_126130_("NEN").m_126130_("CMC").m_206416_(Character.valueOf('P'), IndustrialTags.Items.PLASTIC).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42545_).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42584_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42446_).m_206416_(Character.valueOf('M'), tag).m_176498_(consumer);
        }
    }

    private BlockEntityType getRarityType() {
        if (this.rarity == Rarity.COMMON) {
            return (BlockEntityType)((RegistryObject)ModuleTransportStorage.BLACK_HOLE_TANK_COMMON.getRight()).get();
        }
        if (this.rarity == ModuleCore.SIMPLE_RARITY) {
            return (BlockEntityType)((RegistryObject)ModuleTransportStorage.BLACK_HOLE_TANK_SIMPLE.getRight()).get();
        }
        if (this.rarity == ModuleCore.ADVANCED_RARITY) {
            return (BlockEntityType)((RegistryObject)ModuleTransportStorage.BLACK_HOLE_TANK_ADVANCED.getRight()).get();
        }
        if (this.rarity == ModuleCore.SUPREME_RARITY) {
            return (BlockEntityType)((RegistryObject)ModuleTransportStorage.BLACK_HOLE_TANK_SUPREME.getRight()).get();
        }
        return (BlockEntityType)((RegistryObject)ModuleTransportStorage.BLACK_HOLE_TANK_PITY.getRight()).get();
    }

    public static class BlackHoleTankCapabilityProvider
    implements ICapabilityProvider {
        private final ItemStack stack;
        private LazyOptional<FluidHandlerItemStack> iFluidHandlerItemLazyOptional;

        public BlackHoleTankCapabilityProvider(ItemStack stack, Rarity rarity) {
            this.stack = stack;
            this.iFluidHandlerItemLazyOptional = LazyOptional.of(() -> new BlockFluidHandlerItemStack(stack, new ItemStack((ItemLike)stack.m_41720_()), BlockUtils.getFluidAmountByRarity(rarity), "tank"));
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap != null && cap.equals((Object)ForgeCapabilities.FLUID_HANDLER_ITEM)) {
                return this.iFluidHandlerItemLazyOptional.cast();
            }
            return LazyOptional.empty();
        }
    }

    public static class BlackHoleTankItem
    extends BlockItem {
        private Rarity rarity;

        public BlackHoleTankItem(Block blockIn, Item.Properties builder, Rarity rarity) {
            super(blockIn, builder);
            this.rarity = rarity;
        }

        @Nullable
        public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
            return new BlackHoleTankCapabilityProvider(stack, this.rarity);
        }

        @Nullable
        public String getCreatorModId(ItemStack itemStack) {
            return Component.m_237115_((String)("itemGroup." + this.f_41377_.m_40783_())).getString();
        }
    }
}

