/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbricketyww.block;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.waterwheel.WaterWheelBlockEntity;
import com.simibubi.create.foundation.utility.Lang;
import dev.ftb.mods.ftbricketyww.config.ConfigHolder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class RicketyWaterWheelBlockEntity
extends WaterWheelBlockEntity {
    private int durability = ConfigHolder.maxDurability();

    public RicketyWaterWheelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.m_5776_() && this.hasNetwork() && this.stress > 0.0f) {
            int prevDurability = this.durability;
            this.durability = Math.max(0, this.durability - 1);
            if (this.durability > ConfigHolder.maxDurability()) {
                this.durability = ConfigHolder.maxDurability();
                this.sendData();
            } else if (this.durability == 0) {
                if (prevDurability > 0) {
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.getOrCreateNetwork().updateCapacityFor((KineticBlockEntity)this, 0.0f);
                }
                if (this.f_58857_.f_46441_.m_188499_()) {
                    Vec3 vec = Vec3.m_82539_((Vec3i)this.m_58899_().m_7494_());
                    ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), 10, 0.0, 0.0, 0.0, 0.0);
                }
            } else if (this.durability % (ConfigHolder.maxDurability() / 100) == 0) {
                this.notifyUpdate();
            } else {
                this.m_6596_();
            }
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        int durabilityPct = (int)((float)this.durability / (float)ConfigHolder.maxDurability() * 100.0f);
        Lang.translate((String)"ftbricketyww.goggles.durability", (Object[])new Object[0]).style(ChatFormatting.GRAY).text(ChatFormatting.AQUA, durabilityPct + "%").forGoggles(tooltip);
        return added;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.durability = compound.m_128451_("Durability");
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Durability", this.durability);
    }

    public float getGeneratedSpeed() {
        return this.durability > 0 ? super.getGeneratedSpeed() : 0.0f;
    }
}

