/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.item;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.common.items.FluorescentTubeItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.mojang.math.Vector4f;
import java.util.List;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class FluorescentTubeCallbacks
implements ItemCallback<Key> {
    public static final FluorescentTubeCallbacks INSTANCE = new FluorescentTubeCallbacks();
    private static final List<List<String>> special = List.of(List.of("tube"));

    @Override
    public Key extractKey(ItemStack object, LivingEntity owner) {
        boolean lit = FluorescentTubeItem.isLit(object);
        float min = 0.3f + (lit ? ItemNBTHelper.getFloat(object, "litStrength") * 0.68f : 0.0f);
        float mult = min + (lit ? ApiUtils.RANDOM.nextFloat() * Mth.m_14036_((float)(1.0f - min), (float)0.0f, (float)0.1f) : 0.0f);
        float[] colors = FluorescentTubeItem.getRGBFloat(object, mult);
        return new Key(new Vector4f(colors[0], colors[1], colors[2], colors[3]));
    }

    @Override
    public List<List<String>> getSpecialGroups(ItemStack stack, ItemTransforms.TransformType transform, LivingEntity entity) {
        return special;
    }

    @Override
    public boolean areGroupsFullbright(ItemStack stack, List<String> groups) {
        return groups.size() == 1 && "tube".equals(groups.get(0)) && FluorescentTubeItem.isLit(stack);
    }

    @Override
    public Vector4f getRenderColor(Key object, String group, String material, ShaderCase shaderCase, Vector4f original) {
        if ("tube".equals(group)) {
            return object.color();
        }
        return new Vector4f(0.067f, 0.067f, 0.067f, 1.0f);
    }

    @Override
    public Key getDefaultKey() {
        return new Key(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
    }

    public record Key(Vector4f color) {
    }
}

