/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.common.blocks.metal.MixerBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;

public class MixerRenderer
extends IEBlockEntityRenderer<MixerBlockEntity> {
    public static final String NAME = "mixer_agitator";
    public static DynamicModel AGITATOR;

    public void render(MixerBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!te.formed || te.isDummy() || !te.getLevelNonnull().m_46805_(te.m_58899_())) {
            return;
        }
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        BlockPos blockPos = te.m_58899_();
        BlockState state = te.m_58904_().m_8055_(blockPos);
        if (state.m_60734_() != IEBlocks.Multiblocks.MIXER.get()) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        bufferIn = BERenderUtils.mirror(te, matrixStack, bufferIn);
        matrixStack.m_85836_();
        matrixStack.m_85837_(te.getFacing() == Direction.SOUTH || te.getFacing() == Direction.WEST ? -0.5 : 0.5, 0.0, te.getFacing() == Direction.SOUTH || te.getFacing() == Direction.EAST ? 0.5 : -0.5);
        float agitator = te.animation_agitator - (!te.shouldRenderAsActive() ? 0.0f : (1.0f - partialTicks) * 9.0f);
        matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), agitator, true));
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        blockRenderer.m_110937_().renderModel(matrixStack.m_85850_(), bufferIn.m_6299_(RenderType.m_110451_()), state, AGITATOR.get(), 1.0f, 1.0f, 1.0f, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, RenderType.m_110451_());
        matrixStack.m_85849_();
        matrixStack.m_85837_(te.getFacing() == Direction.SOUTH || te.getFacing() == Direction.WEST ? -0.5 : 0.5, -0.625, te.getFacing() == Direction.SOUTH || te.getFacing() == Direction.EAST ? 0.5 : -0.5);
        for (int i = te.tank.getFluidTypes() - 1; i >= 0; --i) {
            FluidStack fs = te.tank.fluids.get(i);
            if (fs == null || fs.getFluid() == null) continue;
            float yy = (float)fs.getAmount() / (float)te.tank.getCapacity() * 1.0625f;
            matrixStack.m_85837_(0.0, (double)yy, 0.0);
            float w = i < te.tank.getFluidTypes() - 1 || (double)yy >= 0.125 ? 0.8125f : 0.5f + yy * 2.5f;
            double px = w * 16.0f;
            IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fs.getFluid());
            TextureAtlasSprite sprite = ClientUtils.getSprite(props.getStillTexture(fs));
            VertexConsumer consumer = bufferIn.m_6299_(RenderType.m_110451_());
            Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
            int col = props.getTintColor(fs);
            float r = (float)(col >> 16 & 0xFF) / 255.0f;
            float g = (float)(col >> 8 & 0xFF) / 255.0f;
            float b = (float)(col & 0xFF) / 255.0f;
            Vec3 from = new Vec3((double)(-w), 0.0, (double)(-w));
            Vec3 to = new Vec3(0.0, 0.0, 0.0);
            for (int v = 0; v < 4; ++v) {
                Vec3 start = from.m_82520_(v % 2 == 1 ? (double)w : 0.0, 0.0, v > 1 ? (double)w : 0.0);
                Vec3 end = to.m_82520_(v % 2 == 1 ? (double)w : 0.0, 0.0, v > 1 ? (double)w : 0.0);
                float uMin = sprite.m_118367_(v % 2 == 0 ? 16.0 - px : 0.0);
                float uMax = sprite.m_118367_(v % 2 == 0 ? 16.0 : px);
                float vMin = sprite.m_118393_(v > 1 ? 0.0 : 16.0 - px);
                float vMax = sprite.m_118393_(v > 1 ? px : 16.0);
                consumer.m_85982_(matrix4f, (float)start.f_82479_, 0.0f, (float)start.f_82481_).m_85950_(r, g, b, 1.0f).m_7421_(uMin, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLightIn).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_85982_(matrix4f, (float)start.f_82479_, 0.0f, (float)end.f_82481_).m_85950_(r, g, b, 1.0f).m_7421_(uMin, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLightIn).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_85982_(matrix4f, (float)end.f_82479_, 0.0f, (float)end.f_82481_).m_85950_(r, g, b, 1.0f).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLightIn).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_85982_(matrix4f, (float)end.f_82479_, 0.0f, (float)start.f_82481_).m_85950_(r, g, b, 1.0f).m_7421_(uMax, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLightIn).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            }
        }
        matrixStack.m_85849_();
    }
}

