/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.utils.ItemUtils;
import java.util.Collection;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ItemNBTHelper {
    public static boolean hasTag(ItemStack stack) {
        return stack.m_41782_();
    }

    public static boolean hasKey(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) && stack.m_41784_().m_128441_(key);
    }

    public static boolean hasKey(ItemStack stack, String key, int type) {
        return ItemNBTHelper.hasTag(stack) && stack.m_41784_().m_128425_(key, type);
    }

    public static void remove(ItemStack stack, String key) {
        ItemUtils.removeTag(stack, key);
    }

    public static void putInt(ItemStack stack, String key, int val) {
        stack.m_41784_().m_128405_(key, val);
    }

    public static void modifyInt(CompoundTag tagCompound, String key, int mod) {
        tagCompound.m_128405_(key, tagCompound.m_128451_(key) + mod);
    }

    public static int getInt(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? stack.m_41784_().m_128451_(key) : 0;
    }

    public static void putString(ItemStack stack, String key, String val) {
        stack.m_41784_().m_128359_(key, val);
    }

    public static String getString(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? stack.m_41784_().m_128461_(key) : "";
    }

    public static void putLong(ItemStack stack, String key, long val) {
        stack.m_41784_().m_128356_(key, val);
    }

    public static long getLong(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? stack.m_41784_().m_128454_(key) : 0L;
    }

    public static void putIntArray(ItemStack stack, String key, int[] val) {
        stack.m_41784_().m_128385_(key, val);
    }

    public static int[] getIntArray(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? stack.m_41784_().m_128465_(key) : new int[]{};
    }

    public static void putFloat(ItemStack stack, String key, float val) {
        stack.m_41784_().m_128350_(key, val);
    }

    public static void modifyFloat(CompoundTag tagCompound, String key, float mod) {
        tagCompound.m_128350_(key, tagCompound.m_128457_(key) + mod);
    }

    public static float getFloat(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? stack.m_41784_().m_128457_(key) : 0.0f;
    }

    public static void putBoolean(ItemStack stack, String key, boolean val) {
        stack.m_41784_().m_128379_(key, val);
    }

    public static boolean getBoolean(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) && stack.m_41784_().m_128471_(key);
    }

    public static void setTagCompound(ItemStack stack, String key, CompoundTag val) {
        stack.m_41784_().m_128365_(key, (Tag)val);
    }

    public static CompoundTag getTagCompound(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? stack.m_41784_().m_128469_(key) : new CompoundTag();
    }

    public static void setFluidStack(ItemStack stack, String key, FluidStack val) {
        if (val != null && val.getFluid() != null) {
            ItemNBTHelper.setTagCompound(stack, key, val.writeToNBT(new CompoundTag()));
        } else {
            ItemNBTHelper.remove(stack, key);
        }
    }

    public static FluidStack getFluidStack(ItemStack stack, String key) {
        if (ItemNBTHelper.hasTag(stack)) {
            return FluidStack.loadFluidStackFromNBT((CompoundTag)ItemNBTHelper.getTagCompound(stack, key));
        }
        return null;
    }

    public static void setItemStack(ItemStack stack, String key, ItemStack val) {
        stack.m_41784_().m_128365_(key, (Tag)val.m_41739_(new CompoundTag()));
    }

    public static ItemStack getItemStack(ItemStack stack, String key) {
        if (ItemNBTHelper.hasTag(stack) && stack.m_41784_().m_128441_(key)) {
            return ItemStack.m_41712_((CompoundTag)ItemNBTHelper.getTagCompound(stack, key));
        }
        return ItemStack.f_41583_;
    }

    public static void setLore(ItemStack stack, Component ... lore) {
        CompoundTag displayTag = ItemNBTHelper.getTagCompound(stack, "display");
        ListTag list = new ListTag();
        for (Component s : lore) {
            list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)s)));
        }
        displayTag.m_128365_("Lore", (Tag)list);
        ItemNBTHelper.setTagCompound(stack, "display", displayTag);
    }

    public static CompoundTag combineTags(CompoundTag target, CompoundTag add, Pattern pattern) {
        if (target == null || target.m_128456_()) {
            return add.m_6426_();
        }
        for (String key : add.m_128431_()) {
            if (pattern != null && !pattern.matcher(key).matches()) continue;
            if (!target.m_128441_(key)) {
                target.m_128365_(key, add.m_128423_(key));
                continue;
            }
            switch (add.m_128435_(key)) {
                case 1: {
                    target.m_128344_(key, (byte)(target.m_128445_(key) + add.m_128445_(key)));
                    break;
                }
                case 2: {
                    target.m_128376_(key, (short)(target.m_128448_(key) + add.m_128448_(key)));
                    break;
                }
                case 3: {
                    target.m_128405_(key, target.m_128451_(key) + add.m_128451_(key));
                    break;
                }
                case 4: {
                    target.m_128356_(key, target.m_128454_(key) + add.m_128454_(key));
                    break;
                }
                case 5: {
                    target.m_128350_(key, target.m_128457_(key) + add.m_128457_(key));
                    break;
                }
                case 6: {
                    target.m_128347_(key, target.m_128459_(key) + add.m_128459_(key));
                    break;
                }
                case 7: {
                    byte[] bytesTarget = target.m_128463_(key);
                    byte[] bytesAdd = add.m_128463_(key);
                    byte[] bytes = new byte[bytesTarget.length + bytesAdd.length];
                    System.arraycopy(bytesTarget, 0, bytes, 0, bytesTarget.length);
                    System.arraycopy(bytesAdd, 0, bytes, bytesTarget.length, bytesAdd.length);
                    target.m_128382_(key, bytes);
                    break;
                }
                case 8: {
                    target.m_128359_(key, target.m_128461_(key) + add.m_128461_(key));
                    break;
                }
                case 9: {
                    ListTag listTarget = (ListTag)target.m_128423_(key);
                    ListTag listAdd = (ListTag)add.m_128423_(key);
                    listTarget.addAll((Collection)listAdd);
                    target.m_128365_(key, (Tag)listTarget);
                    break;
                }
                case 10: {
                    ItemNBTHelper.combineTags(target.m_128469_(key), add.m_128469_(key), null);
                    break;
                }
                case 11: {
                    int[] intsTarget = target.m_128465_(key);
                    int[] intsAdd = add.m_128465_(key);
                    int[] ints = new int[intsTarget.length + intsAdd.length];
                    System.arraycopy(intsTarget, 0, ints, 0, intsTarget.length);
                    System.arraycopy(intsAdd, 0, ints, intsTarget.length, intsAdd.length);
                    target.m_128385_(key, ints);
                }
            }
        }
        return target;
    }
}

