/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import blusunrize.immersiveengineering.mixin.accessors.FurnaceTEAccess;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class VanillaFurnaceHeater
implements ExternalHeaterHandler.IExternalHeatable {
    private static final int FULLY_HEATED_LIT_TIME = 200;
    private final FurnaceBlockEntity furnace;
    private long blockedUntilGameTime = 0L;

    public VanillaFurnaceHeater(FurnaceBlockEntity furnace) {
        this.furnace = furnace;
    }

    boolean canCook() {
        ItemStack input = this.furnace.m_8020_(0);
        if (input.m_41619_()) {
            return false;
        }
        Optional output = ((FurnaceTEAccess)this.furnace).getQuickCheck().m_213657_((Container)this.furnace, this.furnace.m_58904_());
        if (output.isEmpty()) {
            return false;
        }
        ItemStack existingOutput = this.furnace.m_8020_(2);
        if (existingOutput.m_41619_()) {
            return true;
        }
        ItemStack outStack = ((AbstractCookingRecipe)output.get()).m_8043_();
        if (!existingOutput.m_41656_(outStack)) {
            return false;
        }
        int stackSize = existingOutput.m_41613_() + outStack.m_41613_();
        return stackSize <= this.furnace.m_6893_() && stackSize <= outStack.m_41741_();
    }

    @Override
    public int doHeatTick(int energyAvailable, boolean redstone) {
        long now = this.furnace.m_58904_().m_46467_();
        if (now < this.blockedUntilGameTime) {
            return 0;
        }
        int energyConsumed = 0;
        boolean canCook = this.canCook();
        if (canCook || redstone) {
            int energyToUse;
            ContainerData furnaceData = ((FurnaceTEAccess)this.furnace).getDataAccess();
            int burnTime = furnaceData.m_6413_(0);
            if (burnTime < 200) {
                int heatEnergyRatio = Math.max(1, ExternalHeaterHandler.defaultFurnaceEnergyCost);
                if (burnTime == 0 && energyAvailable < heatEnergyRatio) {
                    this.blockedUntilGameTime = now + 20L;
                    return 0;
                }
                int heatAttempt = Math.min(4, 200 - burnTime);
                int energyToUse2 = Math.min(energyAvailable, heatAttempt * heatEnergyRatio);
                int heat = energyToUse2 / heatEnergyRatio;
                if (heat > 0) {
                    furnaceData.m_8050_(0, burnTime + heat);
                    energyConsumed += heat * heatEnergyRatio;
                    this.setFurnaceActive();
                }
            }
            if (canCook && furnaceData.m_6413_(0) >= 200 && furnaceData.m_6413_(2) < furnaceData.m_6413_(3) - 1 && energyAvailable - energyConsumed > (energyToUse = ExternalHeaterHandler.defaultFurnaceSpeedupCost)) {
                energyConsumed += energyToUse;
                furnaceData.m_8050_(2, furnaceData.m_6413_(2) + 1);
            }
        }
        return energyConsumed;
    }

    public void setFurnaceActive() {
        BlockState oldState = this.furnace.m_58900_();
        if (!((Boolean)oldState.m_61143_((Property)AbstractFurnaceBlock.f_48684_)).booleanValue()) {
            this.furnace.m_58904_().m_46597_(this.furnace.m_58899_(), (BlockState)oldState.m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(true)));
        }
    }
}

