/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computers.generic;

import blusunrize.immersiveengineering.common.blocks.MultiblockBEType;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.CallbackOwner;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.ArcFurnaceCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.AssemblerCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.AutoWorkbenchCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.BottlingMachineCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.CapacitorCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.CrusherCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.DieselGenCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.EnergyMeterCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.ExcavatorCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.FermenterCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.FloodlightCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.MixerCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.RefineryCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.SampleDrillCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.SawmillCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.SiloCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.SqueezerCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.TeslaCoilCallbacks;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.RegistryObject;

public class Callbacks {
    private static final Map<ResourceLocation, CallbackOwner<?>> CALLBACKS = new HashMap();
    private static boolean initialized = false;

    private static <T extends BlockEntity> void register(MultiblockBEType<T> type, CallbackOwner<T> owner) {
        Callbacks.register(type.dummyHolder(), owner);
        Callbacks.register(type.masterHolder(), owner);
    }

    private static <T extends BlockEntity> void register(RegistryObject<BlockEntityType<T>> type, CallbackOwner<T> owner) {
        CALLBACKS.put(type.getId(), owner);
    }

    private static void ensureInitialized() {
        if (initialized) {
            return;
        }
        Callbacks.register(IEBlockEntities.CRUSHER, new CrusherCallbacks());
        Callbacks.register(IEBlockEntities.ARC_FURNACE, new ArcFurnaceCallbacks());
        Callbacks.register(IEBlockEntities.BOTTLING_MACHINE, new BottlingMachineCallbacks());
        Callbacks.register(IEBlockEntities.CAPACITOR_LV, new CapacitorCallbacks("lv"));
        Callbacks.register(IEBlockEntities.CAPACITOR_MV, new CapacitorCallbacks("mv"));
        Callbacks.register(IEBlockEntities.CAPACITOR_HV, new CapacitorCallbacks("hv"));
        Callbacks.register(IEBlockEntities.DIESEL_GENERATOR, new DieselGenCallbacks());
        Callbacks.register(IEBlockEntities.ENERGY_METER, new EnergyMeterCallbacks());
        Callbacks.register(IEBlockEntities.EXCAVATOR, new ExcavatorCallbacks());
        Callbacks.register(IEBlockEntities.FERMENTER, new FermenterCallbacks());
        Callbacks.register(IEBlockEntities.SQUEEZER, new SqueezerCallbacks());
        Callbacks.register(IEBlockEntities.MIXER, new MixerCallbacks());
        Callbacks.register(IEBlockEntities.REFINERY, new RefineryCallbacks());
        Callbacks.register(IEBlockEntities.FLOODLIGHT, new FloodlightCallbacks());
        Callbacks.register(IEBlockEntities.SAMPLE_DRILL, new SampleDrillCallbacks());
        Callbacks.register(IEBlockEntities.TESLACOIL, new TeslaCoilCallbacks());
        Callbacks.register(IEBlockEntities.ASSEMBLER, new AssemblerCallbacks());
        Callbacks.register(IEBlockEntities.AUTO_WORKBENCH, new AutoWorkbenchCallbacks());
        Callbacks.register(IEBlockEntities.SILO, new SiloCallbacks());
        Callbacks.register(IEBlockEntities.SAWMILL, new SawmillCallbacks());
        initialized = true;
    }

    public static Map<ResourceLocation, CallbackOwner<?>> getCallbacks() {
        Callbacks.ensureInitialized();
        return Collections.unmodifiableMap(CALLBACKS);
    }
}

