/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.mixins;

import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.zeith.api.level.ISpoofedRecipeManager;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.event.recipe.SpoofRecipesEvent;
import org.zeith.hammerlib.util.java.Cast;

@Mixin(value={RecipeManager.class})
@Implements(value={@Interface(iface=ISpoofedRecipeManager.class, prefix="isrm$")})
public class RecipeManagerMixin {
    @Shadow(remap=false)
    @Final
    private ICondition.IContext context;
    @Shadow
    public Map<ResourceLocation, Recipe<?>> f_199900_;
    private Map<ResourceLocation, List<ResourceLocation>> hammerLibSpoofByName = SpoofRecipesEvent.gather();

    @Inject(method={"byKey"}, at={@At(value="HEAD")}, cancellable=true)
    private void replaceRecipeId(ResourceLocation id, CallbackInfoReturnable<Optional<? extends Recipe<?>>> cir) {
        if (this.hammerLibSpoofByName.containsKey(id)) {
            Optional<Recipe<?>> recipe = this.findFirstRecipe_HL((Collection<ResourceLocation>)this.hammerLibSpoofByName.getOrDefault(id, List.of(id)));
            if (recipe.isPresent()) {
                cir.setReturnValue(recipe);
            } else {
                HammerLib.LOG.error("Failed to locate recipe with mapping " + id + "=" + this.hammerLibSpoofByName.get(id));
            }
        }
    }

    private Optional<? extends Recipe<?>> findFirstRecipe_HL(Collection<ResourceLocation> rl) {
        return rl.stream().map(this.f_199900_::get).filter(Objects::nonNull).findFirst();
    }

    @Inject(method={"apply*"}, at={@At(value="TAIL")})
    public void reloadRecipes_HammerLib(Map<ResourceLocation, JsonElement> recipes, ResourceManager manager, ProfilerFiller profiler, CallbackInfo ci) {
        RecipeManager mgr = (RecipeManager)Cast.cast(this);
        RecipeHelper.injectRecipes(mgr, this.context);
    }

    public Map<ResourceLocation, List<ResourceLocation>> isrm$getSpoofedRecipes() {
        return this.hammerLibSpoofByName;
    }
}

