/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured.io.buf;

import java.nio.charset.StandardCharsets;

public interface IByteBuf {
    public void writeByte(int var1);

    public void writeShort(int var1);

    public void writeInt(int var1);

    public void writeLong(long var1);

    public void writeFloat(float var1);

    public void writeDouble(double var1);

    default public void writeString(String str) {
        byte[] buf = str.getBytes(StandardCharsets.UTF_8);
        this.writeShort(buf.length);
        this.writeBytes(buf);
    }

    public void writeBytes(byte[] var1, int var2, int var3);

    default public void writeBytes(byte[] bytes) {
        this.writeBytes(bytes, 0, bytes.length);
    }

    public byte readByte();

    public short readShort();

    public int readInt();

    public long readLong();

    public float readFloat();

    public double readDouble();

    default public String readString() {
        byte[] buf = new byte[this.readShort()];
        int len = this.readBytes(buf);
        return new String(buf, 0, len, StandardCharsets.UTF_8);
    }

    public int readBytes(byte[] var1, int var2, int var3);

    default public int readBytes(byte[] buf) {
        return this.readBytes(buf, 0, buf.length);
    }
}

