/*
 * Decompiled with CFR 0.152.
 */
package com.mtcleo05.botania_editor.client.jade;

import com.mtcleo05.botania_editor.config.CommonConfig;
import com.mtcleo05.botania_editor.utils.JadeUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.common.item.BotaniaItems;

@OnlyIn(value=Dist.CLIENT)
public enum GeneratingFlowerComponentProvider implements IBlockComponentProvider
{
    INSTANCE;

    private static final ResourceLocation UID;

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        try {
            GeneratingFlowerBlockEntity generatingFlowerEntity = (GeneratingFlowerBlockEntity)blockAccessor.getBlockEntity();
            if (generatingFlowerEntity != null) {
                IElementHelper elements = iTooltip.getElementHelper();
                IElement icon = elements.item(new ItemStack((ItemLike)BotaniaItems.spark), 0.5f).size(new Vec2(10.0f, 10.0f)).translate(new Vec2(0.0f, -1.0f));
                icon.message(null);
                iTooltip.add(icon);
                iTooltip.append((Component)Component.m_237110_((String)"botania_editor.mana_display", (Object[])new Object[]{generatingFlowerEntity.getMana(), generatingFlowerEntity.getMaxMana()}));
                if (((Boolean)CommonConfig.SHOULD_SHOW_ADVANCED_TOOLTIP.get()).booleanValue() && JadeUtils.JADE_FLOWER_MAP.containsKey(generatingFlowerEntity.getClass())) {
                    List<ForgeConfigSpec.ConfigValue<?>> configs = JadeUtils.JADE_FLOWER_MAP.get(generatingFlowerEntity.getClass());
                    for (int i = 0; i < configs.size(); ++i) {
                        if (i == 0) {
                            iTooltip.add((Component)Component.m_237110_((String)"botania_editor.prod", (Object[])new Object[]{configs.get(i).get()}));
                        }
                        if (i != 1) continue;
                        iTooltip.add((Component)Component.m_237110_((String)"botania_editor.decay", (Object[])new Object[]{configs.get(i).get()}));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }

    static {
        UID = new ResourceLocation("botania_editor", "botania_flower");
    }
}

