/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.accelerateddecay;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.utils.value.IntValue;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class AcceleratedDecay {
    public static final String MOD_ID = "accelerateddecay";
    private static final List<TimedDimBlockPos> timeBasedScanLocations = new ArrayList<TimedDimBlockPos>();
    private static final BlockPos[] SCAN_LOCATIONS;

    public static void init() {
        BlockEvent.BREAK.register(AcceleratedDecay::breakHandler);
        TickEvent.SERVER_LEVEL_POST.register(AcceleratedDecay::levelTick);
    }

    private static void levelTick(ServerLevel serverLevel) {
        if (timeBasedScanLocations.isEmpty()) {
            return;
        }
        Instant now = Instant.now();
        List<TimedDimBlockPos> locations = timeBasedScanLocations.stream().filter(e -> !e.checkAfter.isAfter(now) && serverLevel.m_46472_().equals(e.dim)).toList();
        if (locations.isEmpty()) {
            return;
        }
        for (TimedDimBlockPos location : locations) {
            if (location.player == null || !location.player.m_6084_()) continue;
            Set<BlockPos> yeetLeaves = AcceleratedDecay.seekLeaves((Level)serverLevel, location.pos);
            boolean isFirst = true;
            for (BlockPos yeetLeaf : yeetLeaves) {
                EventResult eventResult;
                BlockState blockState = serverLevel.m_8055_(yeetLeaf);
                if (!blockState.m_204336_(BlockTags.f_13035_) || (eventResult = ((BlockEvent.Break)BlockEvent.BREAK.invoker()).breakBlock((Level)serverLevel, yeetLeaf, blockState, location.player, null)).isFalse()) continue;
                AcceleratedDecay.destroyBlockWithOptionalSoundAndParticles((Level)serverLevel, yeetLeaf, true, 512, location.player, isFirst);
                isFirst = false;
            }
            timeBasedScanLocations.remove(location);
        }
    }

    private static EventResult breakHandler(Level level, BlockPos blockPos, BlockState state, ServerPlayer player, @Nullable IntValue intValue) {
        if (!state.m_204336_(BlockTags.f_13106_)) {
            return EventResult.pass();
        }
        timeBasedScanLocations.add(new TimedDimBlockPos(Instant.now().plus(1L, ChronoUnit.SECONDS), blockPos, (ResourceKey<Level>)level.m_46472_(), player));
        return EventResult.pass();
    }

    private static Set<BlockPos> seekLeaves(Level level, BlockPos pos) {
        HashSet<BlockPos> validLocations = new HashSet<BlockPos>();
        HashSet<BlockPos> walked = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> nextToScan = new ArrayDeque<BlockPos>(List.of(pos));
        while (!nextToScan.isEmpty()) {
            BlockPos currentLocation = (BlockPos)nextToScan.pop();
            for (BlockPos offset : SCAN_LOCATIONS) {
                BlockPos nextLocation = currentLocation.m_121955_((Vec3i)offset);
                BlockState state = level.m_8055_(nextLocation);
                if (!(state.m_60734_() instanceof LeavesBlock) || ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61447_)).booleanValue() || (Integer)state.m_61143_((Property)BlockStateProperties.f_61414_) != 7 || !validLocations.add(nextLocation) || !walked.add(nextLocation)) continue;
                nextToScan.add(nextLocation);
            }
        }
        return validLocations;
    }

    public static void destroyBlockWithOptionalSoundAndParticles(Level level, BlockPos blockPos, boolean bl, int i, ServerPlayer player, boolean soundAndParticles) {
        boolean bl2;
        BlockState blockState = level.m_8055_(blockPos);
        if (blockState.m_60795_()) {
            return;
        }
        FluidState fluidState = level.m_6425_(blockPos);
        if (!(blockState.m_60734_() instanceof BaseFireBlock) && soundAndParticles) {
            level.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
        if (bl) {
            BlockEntity blockEntity = blockState.m_155947_() ? level.m_7702_(blockPos) : null;
            Block.m_49881_((BlockState)blockState, (Level)level, (BlockPos)blockPos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)ItemStack.f_41583_);
        }
        if (bl2 = level.m_6933_(blockPos, fluidState.m_76188_(), 3, i)) {
            level.m_142346_((Entity)player, GameEvent.f_157794_, blockPos);
        }
    }

    static {
        BoundingBox box = new BoundingBox(BlockPos.f_121853_).m_191961_(1);
        SCAN_LOCATIONS = (BlockPos[])BlockPos.m_121919_((BoundingBox)box).map(BlockPos::m_7949_).filter(e -> !e.equals((Object)BlockPos.f_121853_)).distinct().toArray(BlockPos[]::new);
    }

    record TimedDimBlockPos(Instant checkAfter, BlockPos pos, ResourceKey<Level> dim, ServerPlayer player) {
    }
}

