/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.highlights.state;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.client.highlights.HighlightHandler;
import com.teamresourceful.resourcefullib.client.highlights.base.Highlight;
import com.teamresourceful.resourcefullib.client.highlights.base.HighlightLine;
import com.teamresourceful.resourcefullib.client.highlights.state.StateVariant;
import com.teamresourceful.resourcefullib.common.codecs.CodecExtras;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public record HighlightStates(Map<List<BlockState>, Highlight> states) {
    private static final Vector3f CORNER = new Vector3f(-0.5f, 0.0f, -0.5f);
    private static final Vector3f CENTER = new Vector3f(0.5f, 0.0f, 0.5f);
    public static final Codec<BlockModelRotation> ROTATION_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("x").orElse((Object)0).forGetter(ignored -> 0), (App)Codec.INT.fieldOf("y").orElse((Object)0).forGetter(ignored -> 0)).apply((Applicative)instance, (x, y) -> Optional.ofNullable(BlockModelRotation.m_119153_((int)x, (int)y)).orElse(BlockModelRotation.X0_Y0)));
    public static final Codec<Highlight> TRANSLATED_BOX_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)HighlightHandler.HIGHLIGHT_CODEC.fieldOf("highlight").forGetter(i -> i), (App)Vector3f.f_176762_.fieldOf("translation").orElse((Object)Vector3f.f_176763_).forGetter(ignored -> Vector3f.f_176763_), (App)ROTATION_CODEC.fieldOf("rotation").orElse((Object)BlockModelRotation.X0_Y0).forGetter(ignored -> BlockModelRotation.X0_Y0)).apply((Applicative)instance, HighlightStates::createBox));
    public static final Codec<Highlight> BOX_CODEC = CodecExtras.eitherRight(Codec.either(HighlightHandler.HIGHLIGHT_CODEC, TRANSLATED_BOX_CODEC));

    public static Codec<HighlightStates> codec(Block block) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(StateVariant.stateCodec(block), BOX_CODEC).fieldOf("variants").forGetter(HighlightStates::states)).apply((Applicative)instance, HighlightStates::new));
    }

    private static Highlight createBox(Highlight box, Vector3f translation, BlockModelRotation rotation) {
        if (translation.equals((Object)Vector3f.f_176763_) && rotation.equals((Object)BlockModelRotation.X0_Y0)) {
            return box;
        }
        Highlight newBox = box.copy();
        for (HighlightLine line : newBox.lines()) {
            line.start().m_122253_(CORNER);
            line.end().m_122253_(CORNER);
            line.start().m_122251_(rotation.m_6189_().m_121105_());
            line.end().m_122251_(rotation.m_6189_().m_121105_());
            line.start().m_122253_(CENTER);
            line.end().m_122253_(CENTER);
            line.start().m_122253_(translation);
            line.end().m_122253_(translation);
            line.recalculateNormal();
        }
        return newBox;
    }
}

