/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.energeticsheep.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.energeticsheep.RegistryEntries;
import org.cyclops.energeticsheep.entity.EntityAIEatGrassFast;
import org.cyclops.energeticsheep.entity.EntityEnergeticSheepConfig;

@Mod.EventBusSubscriber
@OnlyIn(value=Dist.CLIENT, _interface=PowerableMob.class)
public class EntityEnergeticSheep
extends Sheep
implements PowerableMob {
    public static final ResourceLocation LOOTTABLE_SHEEP_WHITE = new ResourceLocation("energeticsheep", "entities/energetic_sheep/white");
    public static final ResourceLocation LOOTTABLE_SHEEP_ORANGE = new ResourceLocation("energeticsheep", "entities/energetic_sheep/orange");
    public static final ResourceLocation LOOTTABLE_SHEEP_MAGENTA = new ResourceLocation("energeticsheep", "entities/energetic_sheep/magenta");
    public static final ResourceLocation LOOTTABLE_SHEEP_LIGHT_BLUE = new ResourceLocation("energeticsheep", "entities/energetic_sheep/light_blue");
    public static final ResourceLocation LOOTTABLE_SHEEP_YELLOW = new ResourceLocation("energeticsheep", "entities/energetic_sheep/yellow");
    public static final ResourceLocation LOOTTABLE_SHEEP_LIME = new ResourceLocation("energeticsheep", "entities/energetic_sheep/lime");
    public static final ResourceLocation LOOTTABLE_SHEEP_PINK = new ResourceLocation("energeticsheep", "entities/energetic_sheep/pink");
    public static final ResourceLocation LOOTTABLE_SHEEP_GRAY = new ResourceLocation("energeticsheep", "entities/energetic_sheep/gray");
    public static final ResourceLocation LOOTTABLE_SHEEP_LIGHT_GRAY = new ResourceLocation("energeticsheep", "entities/energetic_sheep/light_gray");
    public static final ResourceLocation LOOTTABLE_SHEEP_CYAN = new ResourceLocation("energeticsheep", "entities/energetic_sheep/cyan");
    public static final ResourceLocation LOOTTABLE_SHEEP_PURPLE = new ResourceLocation("energeticsheep", "entities/energetic_sheep/purple");
    public static final ResourceLocation LOOTTABLE_SHEEP_BLUE = new ResourceLocation("energeticsheep", "entities/energetic_sheep/blue");
    public static final ResourceLocation LOOTTABLE_SHEEP_BROWN = new ResourceLocation("energeticsheep", "entities/energetic_sheep/brown");
    public static final ResourceLocation LOOTTABLE_SHEEP_GREEN = new ResourceLocation("energeticsheep", "entities/energetic_sheep/green");
    public static final ResourceLocation LOOTTABLE_SHEEP_RED = new ResourceLocation("energeticsheep", "entities/energetic_sheep/red");
    public static final ResourceLocation LOOTTABLE_SHEEP_BLACK = new ResourceLocation("energeticsheep", "entities/energetic_sheep/black");
    private final Map<DyeColor, ItemLike> woolByColor;
    private static final EntityDataAccessor<Integer> ENERGY = SynchedEntityData.m_135353_(EntityEnergeticSheep.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private IEnergyStorage energyStorage;
    private boolean powerBreeding = false;

    public EntityEnergeticSheep(EntityType<? extends EntityEnergeticSheep> type, Level world) {
        super(type, world);
        this.f_21364_ = 10;
        this.woolByColor = (Map)Util.m_137469_((Object)Maps.newEnumMap(DyeColor.class), p_203402_0_ -> {
            p_203402_0_.put(DyeColor.WHITE, RegistryEntries.ITEM_ENERGETIC_WOOL_WHITE);
            p_203402_0_.put(DyeColor.ORANGE, RegistryEntries.ITEM_ENERGETIC_WOOL_ORANGE);
            p_203402_0_.put(DyeColor.MAGENTA, RegistryEntries.ITEM_ENERGETIC_WOOL_MAGENTA);
            p_203402_0_.put(DyeColor.LIGHT_BLUE, RegistryEntries.ITEM_ENERGETIC_WOOL_LIGHT_BLUE);
            p_203402_0_.put(DyeColor.YELLOW, RegistryEntries.ITEM_ENERGETIC_WOOL_YELLOW);
            p_203402_0_.put(DyeColor.LIME, RegistryEntries.ITEM_ENERGETIC_WOOL_LIME);
            p_203402_0_.put(DyeColor.PINK, RegistryEntries.ITEM_ENERGETIC_WOOL_PINK);
            p_203402_0_.put(DyeColor.GRAY, RegistryEntries.ITEM_ENERGETIC_WOOL_GRAY);
            p_203402_0_.put(DyeColor.LIGHT_GRAY, RegistryEntries.ITEM_ENERGETIC_WOOL_LIGHT_GRAY);
            p_203402_0_.put(DyeColor.CYAN, RegistryEntries.ITEM_ENERGETIC_WOOL_CYAN);
            p_203402_0_.put(DyeColor.PURPLE, RegistryEntries.ITEM_ENERGETIC_WOOL_PURPLE);
            p_203402_0_.put(DyeColor.BLUE, RegistryEntries.ITEM_ENERGETIC_WOOL_BLUE);
            p_203402_0_.put(DyeColor.BROWN, RegistryEntries.ITEM_ENERGETIC_WOOL_BROWN);
            p_203402_0_.put(DyeColor.GREEN, RegistryEntries.ITEM_ENERGETIC_WOOL_GREEN);
            p_203402_0_.put(DyeColor.RED, RegistryEntries.ITEM_ENERGETIC_WOOL_RED);
            p_203402_0_.put(DyeColor.BLACK, RegistryEntries.ITEM_ENERGETIC_WOOL_BLACK);
        });
    }

    public static int getCapacity(DyeColor color) {
        return EntityEnergeticSheep.getCapacity(color, EntityEnergeticSheepConfig.sheepBaseCapacity);
    }

    public static int getCapacity(DyeColor color, int base) {
        return (int)((double)base * (1.0 + (double)(DyeColor.values().length - color.ordinal() - 1) * EntityEnergeticSheepConfig.additionalCapacityColorFactor));
    }

    protected void setEnergyStorage(DyeColor color) {
        this.energyStorage = new EnergyStorage(EntityEnergeticSheep.getCapacity(color)){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                int ret = super.receiveEnergy(maxReceive, simulate);
                if (!simulate) {
                    EntityEnergeticSheep.this.updateEnergy(this.energy);
                }
                return ret;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                int ret = super.extractEnergy(maxExtract, simulate);
                if (!simulate) {
                    EntityEnergeticSheep.this.updateEnergy(this.energy);
                }
                return ret;
            }
        };
    }

    @SubscribeEvent
    public static void onLightning(EntityStruckByLightningEvent event) {
        if (event.getEntity().getClass() == Sheep.class) {
            Sheep sheep = (Sheep)event.getEntity();
            EntityEnergeticSheep energeticSheep = (EntityEnergeticSheep)RegistryEntries.ENTITY_TYPE_ENERGETIC_SHEEP.m_20615_(sheep.f_19853_);
            if (sheep.m_8077_()) {
                energeticSheep.m_6593_(sheep.m_7770_());
            }
            energeticSheep.f_146733_ = sheep.m_146764_();
            energeticSheep.m_29878_(sheep.m_29875_());
            energeticSheep.setFleeceColorInternal(sheep.m_29874_());
            energeticSheep.m_19890_(sheep.m_20185_(), sheep.m_20186_(), sheep.m_20189_(), sheep.f_19859_, sheep.f_19860_);
            sheep.m_142687_(Entity.RemovalReason.DISCARDED);
            sheep.f_19853_.m_7967_((Entity)energeticSheep);
            event.getLightning().m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25363_((Goal)this.f_29803_);
        this.f_29803_ = new EntityAIEatGrassFast(this);
        this.f_21346_.m_25352_(5, (Goal)this.f_29803_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ENERGY, (Object)0);
    }

    protected void updateEnergy(int energy) {
        this.f_19804_.m_135381_(ENERGY, (Object)energy);
        float ratio = (float)energy / (float)this.getCapacity();
        this.m_21051_(Attributes.f_22279_).m_22100_(0.23 * (double)(1.0f + ratio));
        if (energy == 0) {
            this.m_29878_(true);
        } else if (this.m_29875_()) {
            this.m_29878_(false);
        }
    }

    public int getEnergyClient() {
        return (Integer)this.f_19804_.m_135370_(ENERGY);
    }

    public int getCapacity() {
        return this.energyStorage != null ? this.energyStorage.getMaxEnergyStored() : 0;
    }

    public void m_8035_() {
        super.m_8035_();
        if (this.energyStorage != null) {
            this.energyStorage.receiveEnergy(this.energyStorage.getMaxEnergyStored(), false);
        }
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level world, BlockPos pos, int fortune) {
        this.m_29878_(true);
        if (this.energyStorage != null) {
            this.energyStorage.extractEnergy(this.energyStorage.getMaxEnergyStored(), false);
        }
        int i = 1 + this.f_19796_.m_188503_(3);
        ArrayList ret = Lists.newArrayList();
        for (int j = 0; j < i; ++j) {
            ret.add(new ItemStack(this.woolByColor.get(this.m_29874_())));
        }
        this.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
        return ret;
    }

    public void m_5851_(SoundSource soundSource) {
        for (ItemStack item : this.onSheared(null, null, null, null, 0)) {
            ItemEntity itementity = this.m_19983_(item);
            if (itementity == null) continue;
            itementity.m_20256_(itementity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.energyStorage != null) {
            compound.m_128405_("energy", this.energyStorage.getEnergyStored());
            compound.m_128379_("powerBreeding", this.powerBreeding);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFleeceColorInternal(DyeColor.m_41053_((int)compound.m_128445_("Color")));
        this.energyStorage.receiveEnergy(compound.m_128451_("energy"), false);
        this.powerBreeding = compound.m_128471_("powerBreeding");
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityEnergy.ENERGY && this.energyStorage != null) {
            return LazyOptional.of(() -> this.energyStorage).cast();
        }
        return super.getCapability(capability, facing);
    }

    public Sheep m_142606_(ServerLevel world, AgeableMob ageable) {
        int chance = this.powerBreeding ? EntityEnergeticSheepConfig.babyChancePowerBreeding : EntityEnergeticSheepConfig.babyChance;
        this.powerBreeding = false;
        if (chance > 0 && this.f_19796_.m_188503_(chance) == 0) {
            EntityEnergeticSheep child = (EntityEnergeticSheep)RegistryEntries.ENTITY_TYPE_ENERGETIC_SHEEP.m_20615_(this.m_20193_());
            DyeColor color = this.m_29874_() == ((EntityEnergeticSheep)ageable).m_29874_() ? this.m_29874_() : EntityEnergeticSheep.getRandomColor(this.f_19796_);
            child.setFleeceColorInternal(color);
            return child;
        }
        return super.m_142606_(world, ageable);
    }

    public float m_6100_() {
        return this.m_6162_() ? (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 2.0f : (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.5f;
    }

    @Nullable
    public ResourceLocation m_7582_() {
        if (this.m_29875_()) {
            return EntityType.f_20520_.m_20677_();
        }
        switch (this.m_29874_()) {
            default: {
                return LOOTTABLE_SHEEP_WHITE;
            }
            case ORANGE: {
                return LOOTTABLE_SHEEP_ORANGE;
            }
            case MAGENTA: {
                return LOOTTABLE_SHEEP_MAGENTA;
            }
            case LIGHT_BLUE: {
                return LOOTTABLE_SHEEP_LIGHT_BLUE;
            }
            case YELLOW: {
                return LOOTTABLE_SHEEP_YELLOW;
            }
            case LIME: {
                return LOOTTABLE_SHEEP_LIME;
            }
            case PINK: {
                return LOOTTABLE_SHEEP_PINK;
            }
            case GRAY: {
                return LOOTTABLE_SHEEP_GRAY;
            }
            case LIGHT_GRAY: {
                return LOOTTABLE_SHEEP_LIGHT_GRAY;
            }
            case CYAN: {
                return LOOTTABLE_SHEEP_CYAN;
            }
            case PURPLE: {
                return LOOTTABLE_SHEEP_PURPLE;
            }
            case BLUE: {
                return LOOTTABLE_SHEEP_BLUE;
            }
            case BROWN: {
                return LOOTTABLE_SHEEP_BROWN;
            }
            case GREEN: {
                return LOOTTABLE_SHEEP_GREEN;
            }
            case RED: {
                return LOOTTABLE_SHEEP_RED;
            }
            case BLACK: 
        }
        return LOOTTABLE_SHEEP_BLACK;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData livingdata = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setFleeceColorInternal(EntityEnergeticSheep.getRandomColor(this.f_19796_));
        this.energyStorage.receiveEnergy(this.energyStorage.getMaxEnergyStored(), false);
        return livingdata;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_41720_() instanceof DyeItem) {
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    public void m_29855_(DyeColor color) {
    }

    protected void setFleeceColorInternal(DyeColor color) {
        super.m_29855_(color);
        this.setEnergyStorage(color);
    }

    protected static DyeColor getRandomColor(RandomSource random) {
        return DyeColor.values()[random.m_188503_(DyeColor.values().length)];
    }

    protected boolean isPowerBreedingItem(ItemStack stack) {
        for (String name : EntityEnergeticSheepConfig.powerBreedingItems) {
            if (!ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6898_(ItemStack stack) {
        return super.m_6898_(stack) || this.isPowerBreedingItem(stack);
    }

    protected void m_142075_(Player player, InteractionHand hand, ItemStack stack) {
        if (this.isPowerBreedingItem(stack)) {
            this.powerBreeding = true;
            if (!this.m_20193_().m_5776_()) {
                ((ServerLevel)this.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123751_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 10, 0.5, 0.5, 0.5, 2.0);
            }
        }
        super.m_142075_(player, hand, stack);
    }

    public boolean m_7090_() {
        return this.getEnergyClient() > 0;
    }
}

