/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Items.Filters;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public interface IItemMode {
    public ItemTransferMode getItemTransportMode(ItemStack var1);

    public static enum ItemTransferMode {
        ITEMS,
        FLUIDS,
        ENERGY,
        EXPERIENCE,
        DUST;


        public boolean modeItems() {
            return this == ITEMS;
        }

        public boolean modeFluids() {
            return this == FLUIDS;
        }

        public boolean modeEnergy() {
            return this == ENERGY;
        }

        public boolean modeExperience() {
            return this == EXPERIENCE;
        }

        public boolean modeDust() {
            return this == DUST;
        }

        public Component componentTransferMode() {
            if (this.modeItems()) {
                return Component.m_237115_((String)"mowlib.enum.filtertransfermode_item");
            }
            if (this.modeFluids()) {
                return Component.m_237115_((String)"mowlib.enum.filtertransfermode_fluid");
            }
            if (this.modeEnergy()) {
                return Component.m_237115_((String)"mowlib.enum.filtertransfermode_energy");
            }
            if (this.modeExperience()) {
                return Component.m_237115_((String)"mowlib.enum.filtertransfermode_experience");
            }
            if (this.modeDust()) {
                return Component.m_237115_((String)"mowlib.enum.filtertransfermode_dust");
            }
            return Component.m_237115_((String)"mowlib.enum.filtertransfermode_default");
        }

        public String stringTransferMode() {
            switch (this) {
                case ITEMS: {
                    return "item";
                }
                case FLUIDS: {
                    return "fluid";
                }
                case ENERGY: {
                    return "energy";
                }
                case EXPERIENCE: {
                    return "experience";
                }
                case DUST: {
                    return "dust";
                }
            }
            return "default";
        }

        public void iterateTransferMode(ItemStack stackIn) {
            int newValue = this.ordinal() + 1;
            if (newValue >= ItemTransferMode.values().length) {
                newValue = 0;
            }
            this.serializeTransferMode(stackIn, ItemTransferMode.values()[newValue]);
        }

        public void serializeTransferMode(ItemStack stackIn, ItemTransferMode modeToSet) {
            CompoundTag nbt = new CompoundTag();
            if (stackIn.m_41782_()) {
                nbt = stackIn.m_41783_();
            }
            nbt.m_128405_("mowlib_enum_itemtransfermode", modeToSet.ordinal());
            stackIn.m_41751_(nbt);
        }

        public void serializeTransferMode(ItemStack stackIn) {
            CompoundTag nbt = new CompoundTag();
            if (stackIn.m_41782_()) {
                nbt = stackIn.m_41783_();
            }
            nbt.m_128405_("mowlib_enum_itemtransfermode", this.ordinal());
            stackIn.m_41751_(nbt);
        }

        public ItemTransferMode getTransferModeFromStack(ItemStack stackIn) {
            if (stackIn.m_41782_() && stackIn.m_41783_().m_128441_("mowlib_enum_itemtransfermode")) {
                return ItemTransferMode.values()[stackIn.m_41783_().m_128451_("mowlib_enum_itemtransfermode")];
            }
            this.serializeTransferMode(stackIn, ITEMS);
            return ITEMS;
        }

        public static int getTransferModeIntFromStack(ItemStack stackIn) {
            if (stackIn.m_41782_() && stackIn.m_41783_().m_128441_("mowlib_enum_itemtransfermode")) {
                return stackIn.m_41783_().m_128451_("mowlib_enum_itemtransfermode");
            }
            return 0;
        }

        public ChatFormatting getModeColorFormat() {
            return switch (this) {
                case ITEMS -> ChatFormatting.GOLD;
                case FLUIDS -> ChatFormatting.BLUE;
                case ENERGY -> ChatFormatting.RED;
                case EXPERIENCE -> ChatFormatting.GREEN;
                case DUST -> ChatFormatting.LIGHT_PURPLE;
                default -> ChatFormatting.WHITE;
            };
        }
    }
}

