/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.evasiveitems.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class EvasiveConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue onlyEffects;
        public final ForgeConfigSpec.DoubleValue moveStrength;
        public final ForgeConfigSpec.BooleanValue playSound;
        public final ForgeConfigSpec.DoubleValue soundVolume;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General Settings").push("General");
            this.onlyEffects = builder.comment("Only move items of players that have the Stinky effect [Default: false]").define("onlyEffects", false);
            builder.pop();
            builder.comment("Evasive Settings").push("Evasion");
            this.moveStrength = builder.comment("The strength used to move the items away when looked at [Default: 0.14]").defineInRange("moveStrength", 0.14, 0.0, 16.0);
            this.playSound = builder.comment("If items moving should make a sound [Default: true]").define("playSound", true);
            this.soundVolume = builder.comment("If items moving should make a sound [Default: true]").defineInRange("soundVolume", 0.05, 0.0, 1.0);
            builder.pop();
        }
    }
}

