/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.evasiveitems.effect;

import com.mrbysco.evasiveitems.config.EvasiveConfig;
import com.mrbysco.evasiveitems.handler.MovementHandler;
import com.mrbysco.evasiveitems.registry.EvasiveRegistry;
import java.util.ArrayList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class EvasiveEffect
extends MobEffect {
    public EvasiveEffect(int color) {
        super(MobEffectCategory.NEUTRAL, color);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!(player.f_19853_.f_46443_ || player.m_7500_() || player.m_5833_())) {
                ServerLevel serverLevel = (ServerLevel)player.f_19853_;
                ArrayList<ItemEntity> itemEntities = new ArrayList<ItemEntity>();
                serverLevel.m_8583_().forEach(entity -> {
                    ItemEntity itemEntity;
                    if (entity instanceof ItemEntity && !(itemEntity = (ItemEntity)entity).m_32055_().m_41619_() && itemEntity.m_6084_()) {
                        itemEntities.add(itemEntity);
                    }
                });
                itemEntities.removeIf(itemEntity -> !MovementHandler.isLookedAtBy(player, itemEntity));
                double x = player.m_20185_();
                double y = player.m_20186_() + 0.75;
                double z = player.m_20189_();
                Vec3 playerPos = new Vec3(x, y, z);
                float force = ((Double)EvasiveConfig.COMMON.moveStrength.get()).floatValue();
                boolean playSound = (Boolean)EvasiveConfig.COMMON.playSound.get();
                float volume = ((Double)EvasiveConfig.COMMON.soundVolume.get()).floatValue();
                for (ItemEntity item : itemEntities) {
                    Vec3 itemPos = new Vec3(item.m_20185_(), item.m_20186_() - item.m_6049_() + (double)(item.m_20206_() / 2.0f), item.m_20189_());
                    Vec3 push = MovementHandler.getPushMovement(playerPos, itemPos, force);
                    item.m_20256_(push);
                    item.f_19864_ = true;
                    if (!playSound || serverLevel.m_46467_() % 2L != 0L) continue;
                    serverLevel.m_5594_(null, item.m_20183_(), (SoundEvent)EvasiveRegistry.TIP.get(), SoundSource.NEUTRAL, volume, 1.0f);
                }
            }
        }
    }
}

