/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.evasiveitems.handler;

import com.mrbysco.evasiveitems.config.EvasiveConfig;
import com.mrbysco.evasiveitems.registry.EvasiveRegistry;
import java.util.ArrayList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class MovementHandler {
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (((Boolean)EvasiveConfig.COMMON.onlyEffects.get()).booleanValue()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && event.side.isServer() && player != null && !player.m_7500_() && !player.m_5833_()) {
            ServerLevel serverLevel = (ServerLevel)player.f_19853_;
            ArrayList<ItemEntity> itemEntities = new ArrayList<ItemEntity>();
            serverLevel.m_8583_().forEach(entity -> {
                ItemEntity itemEntity;
                if (entity instanceof ItemEntity && !(itemEntity = (ItemEntity)entity).m_32055_().m_41619_() && itemEntity.m_6084_()) {
                    itemEntities.add(itemEntity);
                }
            });
            itemEntities.removeIf(itemEntity -> !MovementHandler.isLookedAtBy(player, itemEntity));
            double x = player.m_20185_();
            double y = player.m_20186_() + 0.75;
            double z = player.m_20189_();
            Vec3 playerPos = new Vec3(x, y, z);
            float force = ((Double)EvasiveConfig.COMMON.moveStrength.get()).floatValue();
            boolean playSound = (Boolean)EvasiveConfig.COMMON.playSound.get();
            float volume = ((Double)EvasiveConfig.COMMON.soundVolume.get()).floatValue();
            for (ItemEntity item : itemEntities) {
                Vec3 itemPos = new Vec3(item.m_20185_(), item.m_20186_() - item.m_6049_() + (double)(item.m_20206_() / 2.0f), item.m_20189_());
                Vec3 push = MovementHandler.getPushMovement(playerPos, itemPos, force);
                item.m_20256_(push);
                item.f_19864_ = true;
                if (!playSound || serverLevel.m_46467_() % 2L != 0L) continue;
                serverLevel.m_5594_(null, item.m_20183_(), (SoundEvent)EvasiveRegistry.TIP.get(), SoundSource.NEUTRAL, volume, 1.0f);
            }
        }
    }

    public static Vec3 getPushMovement(Vec3 playerPos, Vec3 itemPos, float force) {
        Vec3 delta = itemPos.m_82546_(playerPos);
        double distance = delta.m_82553_();
        if (distance > 0.0) {
            delta = delta.m_82541_();
        }
        Vec3 push = delta.m_82490_((double)force);
        return new Vec3(push.f_82479_, 0.0, push.f_82481_);
    }

    public static boolean isLookedAtBy(Player player, ItemEntity item) {
        Vec3 normalizedViewVec = player.m_20252_(1.0f).m_82541_();
        Vec3 subtractedVec = new Vec3(item.m_20185_() - player.m_20185_(), item.m_20188_() - player.m_20188_(), item.m_20189_() - player.m_20189_());
        double d0 = subtractedVec.m_82553_();
        double d1 = normalizedViewVec.m_82526_(subtractedVec = subtractedVec.m_82541_());
        return d1 > 1.0 - 0.75 / d0 ? player.m_142582_((Entity)item) : false;
    }
}

