/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.entity;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.entity.AbstractDynamiteEntity;
import ky.someone.mods.gag.entity.EntityTypeRegistry;
import ky.someone.mods.gag.item.ItemRegistry;
import ky.someone.mods.gag.platform.PlatformInvokers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MiningDynamiteEntity
extends AbstractDynamiteEntity {
    public static final TagKey<Block> MINING_DYNAMITE_EFFECTIVE = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)GAGUtil.id("mining_dynamite_effective"));

    public MiningDynamiteEntity(EntityType<? extends MiningDynamiteEntity> type, Level level) {
        super(type, level);
    }

    public MiningDynamiteEntity(double x, double y, double z, Level level) {
        super((EntityType<? extends AbstractDynamiteEntity>)((EntityType)EntityTypeRegistry.MINING_DYNAMITE.get()), x, y, z, level);
    }

    public MiningDynamiteEntity(LivingEntity owner, Level level) {
        super((EntityType<? extends AbstractDynamiteEntity>)((EntityType)EntityTypeRegistry.MINING_DYNAMITE.get()), owner, level);
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 vec3 = this.m_20184_();
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20165_(-vec3.f_82479_) + this.f_19796_.m_188500_() * 0.6 - 0.3, this.m_20227_(-vec3.f_82480_) + this.f_19796_.m_188500_() * (double)this.m_20206_(), this.m_20246_(-vec3.f_82481_) + this.f_19796_.m_188500_() * 0.6 - 0.3, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    protected void m_5790_(EntityHitResult hitEntity) {
        Entity entity;
        super.m_5790_(hitEntity);
        if (((Boolean)GAGConfig.Dynamite.MINING_GIVES_HASTE.get()).booleanValue() && (entity = hitEntity.m_82443_()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity2.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 160, 1, false, false));
            entity2.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 60, 1, false, false));
        }
    }

    @Override
    public void detonate(Vec3 pos) {
        Integer r = (Integer)GAGConfig.Dynamite.MINING_RADIUS.get();
        BlockMiningExplosion explosion = new BlockMiningExplosion(this.f_19853_, (Entity)this, pos.f_82479_, pos.f_82480_, pos.f_82481_, r.intValue());
        if (!PlatformInvokers.explosionPre(this.f_19853_, explosion)) {
            explosion.m_46061_();
            explosion.m_46075_(false);
            for (Player player : this.f_19853_.m_6907_()) {
                if (!(player.m_20280_((Entity)this) < 4096.0)) continue;
                ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundExplodePacket(pos.f_82479_, pos.f_82480_, pos.f_82481_, (float)r.intValue(), explosion.m_46081_(), null));
            }
        }
    }

    protected Item m_7881_() {
        return (Item)ItemRegistry.MINING_DYNAMITE.get();
    }

    private static class BlockMiningExplosion
    extends Explosion {
        public BlockMiningExplosion(Level level, @Nullable Entity entity, double x, double y, double z, float radius) {
            super(level, entity, null, new ExplosionDamageCalculator(){

                public Optional<Float> m_6617_(Explosion explosion, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
                    if (!fluidState.m_76178_()) {
                        return Optional.empty();
                    }
                    Optional orig = super.m_6617_(explosion, blockGetter, blockPos, blockState, fluidState);
                    return orig.map(f -> {
                        if (blockState.m_204336_(MINING_DYNAMITE_EFFECTIVE)) {
                            return Float.valueOf(f.floatValue() * 0.75f);
                        }
                        return f;
                    });
                }

                public boolean m_6714_(Explosion explosion, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, float f) {
                    return blockState.m_60819_().m_76178_() && super.m_6714_(explosion, blockGetter, blockPos, blockState, f);
                }
            }, x, y, z, radius, false, Explosion.BlockInteraction.BREAK);
        }

        public void m_46061_() {
            this.f_46012_.m_142346_(this.f_46016_, GameEvent.f_157812_, new BlockPos(this.f_46013_, this.f_46014_, this.f_46015_));
            HashSet set = Sets.newHashSet();
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    block2: for (int l = 0; l < 16; ++l) {
                        if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                        double d = (float)j / 15.0f * 2.0f - 1.0f;
                        double e = (float)k / 15.0f * 2.0f - 1.0f;
                        double f = (float)l / 15.0f * 2.0f - 1.0f;
                        double g = Math.sqrt(d * d + e * e + f * f);
                        d /= g;
                        e /= g;
                        f /= g;
                        double m = this.f_46013_;
                        double n = this.f_46014_;
                        double o = this.f_46015_;
                        float p = 0.3f;
                        for (float h = this.f_46017_ * (0.7f + this.f_46012_.f_46441_.m_188501_() * 0.6f); h > 0.0f; h -= 0.22500001f) {
                            BlockPos blockPos = new BlockPos(m, n, o);
                            BlockState blockState = this.f_46012_.m_8055_(blockPos);
                            FluidState fluidState = this.f_46012_.m_6425_(blockPos);
                            if (!this.f_46012_.m_46739_(blockPos)) continue block2;
                            Optional optional = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, blockPos, blockState, fluidState);
                            if (optional.isPresent()) {
                                h -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                            }
                            if (h > 0.0f && this.f_46019_.m_6714_((Explosion)this, (BlockGetter)this.f_46012_, blockPos, blockState, h)) {
                                set.add(blockPos);
                            }
                            m += d * (double)0.3f;
                            n += e * (double)0.3f;
                            o += f * (double)0.3f;
                        }
                    }
                }
            }
            this.m_46081_().addAll(set);
        }
    }
}

