/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import java.util.List;
import java.util.Objects;
import ky.someone.mods.gag.GAG;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.item.GAGItem;
import ky.someone.mods.gag.item.ItemRegistry;
import ky.someone.mods.gag.misc.Pigment;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PigmentJarItem
extends GAGItem {
    public static final String PIGMENT_NBT_KEY = "pigment";
    public static final String COLOR_NBT_KEY = "color";
    public static final String AMOUNT_NBT_KEY = "amount";
    public static final int MAX_AMOUNT = 64;
    public static final int DYE_AMOUNT = 4;

    public PigmentJarItem() {
        super(new Item.Properties().m_41491_(GAG.CREATIVE_TAB).m_41487_(16));
    }

    @Nullable
    public static Pigment getPigment(ItemStack stack) {
        CompoundTag pigmentTag = stack.m_41737_(PIGMENT_NBT_KEY);
        if (pigmentTag == null) {
            return null;
        }
        int color = pigmentTag.m_128451_(COLOR_NBT_KEY);
        int amount = pigmentTag.m_128451_(AMOUNT_NBT_KEY);
        return Pigment.ofRgb(color, amount);
    }

    public static boolean isEmpty(ItemStack stack) {
        Pigment pigment = PigmentJarItem.getPigment(stack);
        return pigment == null || pigment.isEmpty();
    }

    public static int getRgbColor(ItemStack stack) {
        Pigment pigment = PigmentJarItem.getPigment(stack);
        return pigment == null ? -1 : pigment.rgb();
    }

    public static int getColorAmount(ItemStack stack) {
        Pigment pigment = PigmentJarItem.getPigment(stack);
        return pigment == null ? 0 : pigment.amount();
    }

    public static boolean isNonEmptyJar(ItemStack stack) {
        return stack.m_150930_((Item)ItemRegistry.PIGMENT_JAR.get()) && !PigmentJarItem.isEmpty(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        if (PigmentJarItem.isEmpty(stack)) {
            list.add((Component)Component.m_237115_((String)"item.gag.pigment_jar.contents.empty").m_130940_(ChatFormatting.ITALIC).m_130938_(GAGUtil.TOOLTIP_FLAVOUR));
            GAGUtil.appendInfoTooltip(list, List.of(Component.m_237115_((String)"item.gag.pigment_jar.info.empty.1").m_130938_(GAGUtil.TOOLTIP_MAIN), Component.m_237115_((String)"item.gag.pigment_jar.info.empty.2").m_130938_(GAGUtil.TOOLTIP_EXTRA)));
        } else {
            Pigment pigment = Objects.requireNonNull(PigmentJarItem.getPigment(stack));
            list.add((Component)Component.m_237110_((String)"item.gag.pigment_jar.contents", (Object[])new Object[]{GAGUtil.asStyledValue(pigment.amount(), 32.0, Integer.toString(pigment.amount())), Component.m_237113_((String)pigment.hex()).m_130938_(s -> s.m_178520_(pigment.rgb()))}).m_130938_(GAGUtil.TOOLTIP_FLAVOUR));
            GAGUtil.appendInfoTooltip(list, List.of(Component.m_237115_((String)"item.gag.pigment_jar.info.filled.1").m_130938_(GAGUtil.TOOLTIP_MAIN), Component.m_237115_((String)"item.gag.pigment_jar.info.filled.2").m_130938_(GAGUtil.TOOLTIP_EXTRA)));
        }
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> stacks) {
        if (this.m_220152_(tab)) {
            stacks.add((Object)this.m_7968_());
            for (DyeColor color : DyeColor.values()) {
                stacks.add((Object)Pigment.forText(color).asJar());
            }
        }
    }

    public Component m_7626_(ItemStack stack) {
        Component name = super.m_7626_(stack);
        Pigment pigment = PigmentJarItem.getPigment(stack);
        if (pigment == null) {
            return name;
        }
        return name.m_6881_().m_130938_(s -> s.m_178520_(pigment.rgb()));
    }
}

