/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.recipe.pigment;

import java.util.Map;
import ky.someone.mods.gag.item.ItemRegistry;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.misc.Pigment;
import ky.someone.mods.gag.recipe.GAGRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class PigmentJarLeatherDyingRecipe
extends CustomRecipe {
    private static final Map<Item, Integer> VALID_ITEMS = Map.of(Items.f_42407_, 5, Items.f_42408_, 8, Items.f_42462_, 7, Items.f_42463_, 4, Items.f_42654_, 7);

    public PigmentJarLeatherDyingRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack leatherItem = ItemStack.f_41583_;
        boolean hasPigment = false;
        int pigmentAmount = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            DyeableLeatherItem item;
            ItemStack stack = container.m_8020_(i);
            Item item2 = stack.m_41720_();
            if (item2 instanceof DyeableLeatherItem && VALID_ITEMS.containsKey(item = (DyeableLeatherItem)item2)) {
                if (!leatherItem.m_41619_()) {
                    return false;
                }
                leatherItem = stack;
                continue;
            }
            if (stack.m_150930_((Item)ItemRegistry.PIGMENT_JAR.get())) {
                hasPigment = true;
                pigmentAmount += PigmentJarItem.getColorAmount(stack);
                continue;
            }
            item2 = stack.m_41720_();
            if (item2 instanceof DyeItem) {
                DyeItem dye = (DyeItem)item2;
                pigmentAmount += 4;
                continue;
            }
            if (stack.m_41619_()) continue;
            return false;
        }
        return !leatherItem.m_41619_() && hasPigment && pigmentAmount >= VALID_ITEMS.get(leatherItem.m_41720_());
    }

    public ItemStack assemble(CraftingContainer container) {
        ItemStack leatherItem = ItemStack.f_41583_;
        Pigment output = Pigment.EMPTY;
        for (int i = 0; i < container.m_6643_(); ++i) {
            Pigment pigment;
            DyeableLeatherItem item;
            ItemStack stack = container.m_8020_(i);
            Item item2 = stack.m_41720_();
            if (item2 instanceof DyeableLeatherItem && VALID_ITEMS.containsKey(item = (DyeableLeatherItem)item2)) {
                if (!leatherItem.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                leatherItem = stack.m_41777_();
                if (!item.m_41113_(stack)) continue;
                Pigment leatherPigment = Pigment.ofRgb(item.m_41121_(stack), VALID_ITEMS.get(item));
                output = output.mix(leatherPigment);
                continue;
            }
            if (stack.m_150930_((Item)ItemRegistry.PIGMENT_JAR.get())) {
                pigment = PigmentJarItem.getPigment(stack);
                output = output.mix(pigment);
                continue;
            }
            pigment = stack.m_41720_();
            if (!(pigment instanceof DyeItem)) continue;
            DyeItem dye = (DyeItem)pigment;
            Pigment dyePigment = Pigment.forLeather(dye.m_41089_());
            output = output.mix(dyePigment);
        }
        if (leatherItem.m_41619_() || output.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ((DyeableLeatherItem)leatherItem.m_41720_()).m_41115_(leatherItem, output.rgb());
        return leatherItem;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList remaining = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (!PigmentJarItem.isNonEmptyJar(stack)) continue;
            remaining.set(i, (Object)((Item)ItemRegistry.PIGMENT_JAR.get()).m_7968_());
        }
        return remaining;
    }

    public boolean m_8004_(int i, int j) {
        return i * j >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)GAGRecipeSerializers.PIGMENT_JAR_MIXING.get();
    }
}

