/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.lwjgl.opengl.GL11;

public abstract class RecipeAppendix<T>
extends SectionAppendix {
    protected static final int SLOT_SIZE = 16;
    protected static final int TICK_DELAY = 30;
    protected T recipe;
    protected Map<AdvancedButtonEnum, AdvancedButton> renderItemHolders = Maps.newHashMap();

    public RecipeAppendix(IInfoBook infoBook, T recipe) {
        super(infoBook);
        this.recipe = recipe;
    }

    protected int getTick(ScreenInfoBook gui) {
        return gui.getTick() / 30;
    }

    protected ItemStack prepareItemStacks(ItemStack[] itemStacks, int tick) {
        return this.prepareItemStacks(Arrays.asList(itemStacks), tick);
    }

    protected ItemStack prepareItemStacks(List<ItemStack> itemStacks, int tick) {
        if (itemStacks.size() == 0) {
            return ItemStack.f_41583_;
        }
        return this.prepareItemStack(itemStacks.get(tick % itemStacks.size()).m_41777_(), tick);
    }

    protected ItemStack prepareItemStack(ItemStack itemStack, int tick) {
        return itemStack;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderItem(ScreenInfoBook gui, PoseStack matrixStack, int x, int y, ItemStack itemStack, int mx, int my, AdvancedButtonEnum buttonEnum) {
        this.renderItem(gui, matrixStack, x, y, itemStack, mx, my, buttonEnum, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderItem(ScreenInfoBook gui, PoseStack matrixStack, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, AdvancedButtonEnum buttonEnum) {
        this.renderItem(gui, matrixStack, x, y, itemStack, mx, my, renderOverlays, buttonEnum, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderItem(ScreenInfoBook gui, PoseStack matrixStack, int x, int y, ItemStack itemStack, int mx, int my, AdvancedButtonEnum buttonEnum, float chance) {
        this.renderItem(gui, matrixStack, x, y, itemStack, mx, my, true, buttonEnum, chance);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderItem(ScreenInfoBook gui, PoseStack matrixStack, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, AdvancedButtonEnum buttonEnum, float chance) {
        RecipeAppendix.renderItemForButton(gui, matrixStack, x, y, itemStack, mx, my, renderOverlays, buttonEnum != null ? (ItemButton)this.renderItemHolders.get(buttonEnum) : null, chance);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemForButton(ScreenInfoBook gui, PoseStack matrixStack, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, ItemButton button) {
        RecipeAppendix.renderItemForButton(gui, matrixStack, x, y, itemStack, mx, my, renderOverlays, button, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemForButton(ScreenInfoBook gui, PoseStack matrixStack, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, ItemButton button, float chance) {
        if (renderOverlays) {
            gui.drawOuterBorder(matrixStack, x, y, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
        }
        if (!itemStack.m_41619_()) {
            ItemRenderer renderItem = Minecraft.m_91087_().m_91291_();
            matrixStack.m_85836_();
            GlStateManager.m_84525_();
            GlStateManager.m_84328_((int)770, (int)771);
            Lighting.m_84931_();
            GL11.glEnable((int)2929);
            renderItem.m_115203_(itemStack, x, y);
            if (renderOverlays) {
                renderItem.m_115169_(Minecraft.m_91087_().f_91062_, itemStack, x, y);
            }
            Lighting.m_84930_();
            matrixStack.m_85849_();
            GL11.glDisable((int)2929);
            if (chance != 1.0f) {
                String chanceString = chance * 100.0f + "%";
                gui.drawScaledCenteredString(matrixStack, chanceString, x - 4, y + 3, gui.getFont().m_92895_(chanceString), 1.0f, 18, Helpers.RGBToInt(255, 255, 255), true);
            }
            if (button != null && renderOverlays) {
                button.update(x, y, itemStack, gui);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderFluid(ScreenInfoBook gui, PoseStack matrixStack, int x, int y, FluidStack fluidStack, int mx, int my, AdvancedButtonEnum buttonEnum) {
        this.renderFluid(gui, matrixStack, x, y, fluidStack, mx, my, true, buttonEnum);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderFluid(ScreenInfoBook gui, PoseStack matrixStack, int x, int y, FluidStack fluidStack, int mx, int my, boolean renderOverlays, AdvancedButtonEnum buttonEnum) {
        RecipeAppendix.renderFluidForButton(gui, matrixStack, x, y, fluidStack, mx, my, renderOverlays, buttonEnum != null ? (FluidButton)this.renderItemHolders.get(buttonEnum) : null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderFluidForButton(ScreenInfoBook gui, PoseStack matrixStack, int x, int y, FluidStack fluidStack, int mx, int my, boolean renderOverlays, FluidButton button) {
        if (renderOverlays) {
            gui.drawOuterBorder(matrixStack, x, y, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
        }
        if (!fluidStack.isEmpty()) {
            GuiHelpers.renderFluidSlot((GuiComponent)gui, matrixStack, fluidStack, x, y);
            if (button != null && renderOverlays) {
                button.update(x, y, fluidStack, gui);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemTooltip(ScreenInfoBook gui, PoseStack matrixStack, int x, int y, ItemStack itemStack, int mx, int my) {
        matrixStack.m_85836_();
        if (mx >= x && my >= y && mx <= x + 16 && my <= y + 16 && !itemStack.m_41619_()) {
            gui.m_6057_(matrixStack, itemStack, mx, my);
        }
        matrixStack.m_85849_();
        GlStateManager.m_84525_();
        GlStateManager.m_84328_((int)770, (int)771);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderFluidTooltip(ScreenInfoBook gui, PoseStack matrixStack, int x, int y, FluidStack fluidStack, int mx, int my) {
        matrixStack.m_85836_();
        if (mx >= x && my >= y && mx <= x + 16 && my <= y + 16 && !fluidStack.isEmpty()) {
            ArrayList lines = Lists.newArrayList();
            lines.add(FormattedCharSequence.m_13714_((String)L10NHelpers.localize(fluidStack.getTranslationKey(), new Object[0]), (Style)Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)fluidStack.getFluid().getFluidType().getRarity((FluidStack)fluidStack).f_43022_))));
            lines.add(FormattedCharSequence.m_13714_((String)(fluidStack.getAmount() + " mB"), (Style)Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY))));
            gui.m_96617_(matrixStack, lines, mx, my);
        }
        matrixStack.m_85849_();
        GlStateManager.m_84525_();
        GlStateManager.m_84328_((int)770, (int)771);
    }

    @Override
    protected int getHeight() {
        return this.getHeightInner() + this.getAdditionalHeight();
    }

    protected abstract int getHeightInner();

    protected int getAdditionalHeight() {
        return 5;
    }

    @Override
    protected int getOffsetY() {
        return this.getAdditionalHeight();
    }

    protected abstract String getUnlocalizedTitle();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public final void drawElement(ScreenInfoBook gui, PoseStack matrixStack, int x, int y, int width, int height, int page, int mx, int my) {
        int yOffset = this.getAdditionalHeight();
        gui.drawOuterBorder(matrixStack, x - 1, y - 1 - yOffset, this.getWidth() + 2, this.getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
        gui.drawTextBanner(matrixStack, x + width / 2, y - 2 - yOffset);
        gui.drawScaledCenteredString(matrixStack, L10NHelpers.localize(this.getUnlocalizedTitle(), new Object[0]), x, y - 2 - yOffset, width, 0.9f, gui.getBannerWidth() - 6, gui.getTitleColor());
        this.drawElementInner(gui, matrixStack, x, y, width, height, page, mx, my);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void postDrawElement(ScreenInfoBook gui, PoseStack matrixStack, int x, int y, int width, int height, int page, int mx, int my) {
        this.renderToolTips(gui, matrixStack, mx, my);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void drawElementInner(ScreenInfoBook var1, PoseStack var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    @OnlyIn(value=Dist.CLIENT)
    protected void renderToolTips(ScreenInfoBook gui, PoseStack matrixStack, int mx, int my) {
        for (AdvancedButton renderItemHolder : this.renderItemHolders.values()) {
            renderItemHolder.renderTooltip(matrixStack, mx, my);
        }
    }

    @Override
    public void preBakeElement(InfoSection infoSection) {
        this.renderItemHolders.clear();
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
        infoSection.addAdvancedButtons(this.getPage(), this.renderItemHolders.values());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemButton
    extends ElementButton<ItemStack> {
        public ItemButton(IInfoBook infoBook) {
            super(infoBook);
        }

        @Override
        public void update(int x, int y, ItemStack element, ScreenInfoBook gui) {
            super.update(x, y, element.m_41619_() ? null : element, gui);
        }

        @Override
        public void renderTooltip(PoseStack matrixStack, int mx, int my) {
            RecipeAppendix.renderItemTooltip(this.gui, matrixStack, this.f_93620_, this.f_93621_, (ItemStack)this.getElement(), mx, my);
        }

        @Override
        protected String getTranslationKey(ItemStack element) {
            return element.m_41778_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FluidButton
    extends ElementButton<FluidStack> {
        public FluidButton(IInfoBook infoBook) {
            super(infoBook);
        }

        @Override
        protected String getTranslationKey(FluidStack element) {
            return element.getTranslationKey();
        }

        @Override
        public void renderTooltip(PoseStack matrixStack, int mx, int my) {
            RecipeAppendix.renderFluidTooltip(this.gui, matrixStack, this.f_93620_, this.f_93621_, (FluidStack)this.getElement(), mx, my);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class ElementButton<E>
    extends AdvancedButton {
        private final IInfoBook infoBook;
        private E element;

        public ElementButton(IInfoBook infoBook) {
            this.infoBook = infoBook;
        }

        public E getElement() {
            return this.element;
        }

        public void update(int x, int y, E element, ScreenInfoBook gui) {
            this.element = element;
            InfoSection target = null;
            if (this.element != null) {
                String translationKey = this.getTranslationKey(element);
                Pair<InfoSection, Integer> pair = this.infoBook.getConfigLinks().get(translationKey);
                if (pair != null) {
                    target = (InfoSection)pair.getLeft();
                }
            }
            super.update(x, y, (Component)Component.m_237113_((String)"empty"), target, gui);
        }

        protected abstract String getTranslationKey(E var1);

        @Override
        public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.isVisible() && this.isHover(mouseX, mouseY)) {
                this.gui.drawOuterBorder(matrixStack, this.f_93620_, this.f_93621_, 16, 16, 0.392f, 0.392f, 0.6f, 0.9f);
            }
        }

        @Override
        public boolean isVisible() {
            return super.isVisible() && this.element != null;
        }
    }
}

