/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.corelib.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import de.maxhenkel.easypiglins.corelib.client.RenderUtils;
import de.maxhenkel.easypiglins.corelib.helpers.AbstractStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class WrappedFluidStack
extends AbstractStack<FluidStack> {
    public WrappedFluidStack(FluidStack stack) {
        super(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack matrixStack, int x, int y) {
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)((FluidStack)this.stack).getFluid());
        TextureAtlasSprite texture = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(extensions.getStillTexture((FluidStack)this.stack));
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        int color = extensions.getTintColor((FluidStack)this.stack);
        RenderSystem.m_157429_((float)RenderUtils.getRedFloat(color), (float)RenderUtils.getGreenFloat(color), (float)RenderUtils.getBlueFloat(color), (float)RenderUtils.getAlphaFloat(color));
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture.m_118414_().m_118330_());
        WrappedFluidStack.fluidBlit(matrixStack, x, y, 16, 16, texture, color);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getTooltip(Screen screen) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(this.getDisplayName());
        if (Minecraft.m_91087_().f_91066_.f_92125_) {
            ResourceLocation registryName = ForgeRegistries.FLUIDS.getKey((Object)((FluidStack)this.stack).getFluid());
            if (registryName != null) {
                tooltip.add((Component)Component.m_237113_((String)registryName.toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (((FluidStack)this.stack).hasTag()) {
                tooltip.add((Component)Component.m_237110_((String)"item.nbt_tags", (Object[])new Object[]{((FluidStack)this.stack).getTag().m_128431_().size()}).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        return tooltip;
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237113_((String)"").m_7220_(((FluidStack)this.stack).getDisplayName()).m_130938_(((FluidStack)this.stack).getFluid().getFluidType().getRarity().getStyleModifier());
    }

    @Override
    public boolean isEmpty() {
        return ((FluidStack)this.stack).isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void fluidBlit(PoseStack matrixStack, int x, int y, int width, int height, TextureAtlasSprite sprite, int color) {
        WrappedFluidStack.innerBlit(matrixStack.m_85850_().m_85861_(), x, x + width, y, y + height, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), (sprite.m_118412_() - sprite.m_118411_()) * (float)height / 16.0f + sprite.m_118411_(), color);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void innerBlit(Matrix4f matrix, int x1, int x2, int y1, int y2, float minU, float maxU, float minV, float maxV, int color) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix, (float)x1, (float)y2, 0.0f).m_7421_(minU, maxV).m_6122_(RenderUtils.getRed(color), RenderUtils.getGreen(color), RenderUtils.getBlue(color), 255).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x2, (float)y2, 0.0f).m_7421_(maxU, maxV).m_6122_(RenderUtils.getRed(color), RenderUtils.getGreen(color), RenderUtils.getBlue(color), 255).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x2, (float)y1, 0.0f).m_7421_(maxU, minV).m_6122_(RenderUtils.getRed(color), RenderUtils.getGreen(color), RenderUtils.getBlue(color), 255).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x1, (float)y1, 0.0f).m_7421_(minU, minV).m_6122_(RenderUtils.getRed(color), RenderUtils.getGreen(color), RenderUtils.getBlue(color), 255).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }
}

