/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ftbskiescompanion.common.blockentity;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidBlock;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.impl.InsertOnlyFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedBlockFluidContainer;
import earth.terrarium.botarium.common.item.ItemContainerBlock;
import earth.terrarium.botarium.common.item.SerializableContainer;
import earth.terrarium.botarium.common.item.SimpleItemContainer;
import earth.terrarium.ftbskiescompanion.common.recipe.CrystallizationRecipe;
import earth.terrarium.ftbskiescompanion.common.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.xplat.XplatAbstractions;

public class LiquidCrystallizerBlockEntity
extends KineticBlockEntity
implements ItemContainerBlock,
BotariumFluidBlock<WrappedBlockFluidContainer>,
ManaReceiver {
    private SerializableContainer container;
    private WrappedBlockFluidContainer fluidContainer;
    private int timer;
    private int mana;
    private CrystallizationRecipe lastRecipe;

    public LiquidCrystallizerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.LIQUID_CRYSTALLIZER.get(), pos, state);
    }

    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.timer > 0) {
            this.timer -= this.getProcessingSpeed();
            if (this.f_58857_.f_46443_) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
            }
            return;
        }
        if (this.getFluidContainer().isEmpty()) {
            return;
        }
        FluidHolder holder = (FluidHolder)this.getFluidContainer().getFluids().get(0);
        if (this.lastRecipe == null || !this.lastRecipe.input().test(holder)) {
            CrystallizationRecipe recipe = CrystallizationRecipe.find(holder, this.f_58857_);
            if (recipe == null) {
                this.lastRecipe = null;
                this.timer = 100;
                this.sendData();
            } else {
                this.lastRecipe = recipe;
                this.timer = this.lastRecipe.processTime();
                this.sendData();
            }
            return;
        }
        this.timer = this.lastRecipe.processTime();
        this.sendData();
    }

    private void process() {
        FluidHolder holder = (FluidHolder)this.getFluidContainer().getFluids().get(0);
        if (this.lastRecipe == null || !this.lastRecipe.input().test(holder)) {
            CrystallizationRecipe recipe = CrystallizationRecipe.find(holder, this.f_58857_);
            if (recipe == null) {
                return;
            }
            this.lastRecipe = recipe;
        }
        if (this.mana < this.lastRecipe.mana()) {
            return;
        }
        ItemStack stack = XplatAbstractions.INSTANCE.insertToInventory(this.f_58857_, this.m_58899_(), null, this.lastRecipe.result().m_41777_(), true);
        if (stack.m_41619_()) {
            XplatAbstractions.INSTANCE.insertToInventory(this.f_58857_, this.m_58899_(), null, this.lastRecipe.result().m_41777_(), false);
            FluidHolder toExtract = holder.copyWithAmount(this.lastRecipe.input().getFluidAmount());
            this.getFluidContainer().internalExtract(toExtract, false);
            this.mana -= this.lastRecipe.mana();
        }
        this.sendData();
        this.m_6596_();
    }

    public int getProcessingSpeed() {
        return Mth.m_14045_((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    public void spawnParticles() {
        if (this.lastRecipe == null) {
            return;
        }
        ItemStack stackInSlot = this.lastRecipe.result().m_41777_();
        ItemParticleOption data = new ItemParticleOption(ParticleTypes.f_123752_, stackInSlot);
        float angle = this.f_58857_.f_46441_.m_188501_() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, 0.5);
        offset = VecHelper.rotate((Vec3)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 target = VecHelper.rotate((Vec3)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (Direction.Axis)Direction.Axis.Y);
        Vec3 center = offset.m_82549_(VecHelper.getCenterOf((Vec3i)this.f_58858_));
        target = VecHelper.offsetRandomly((Vec3)target.m_82546_(offset), (RandomSource)this.f_58857_.f_46441_, (float)0.0078125f);
        this.f_58857_.m_7106_((ParticleOptions)data, center.f_82479_, center.f_82480_, center.f_82481_, target.f_82479_, target.f_82480_, target.f_82481_);
    }

    public SerializableContainer getContainer() {
        if (this.container == null) {
            this.container = new SimpleItemContainer((BlockEntity)this, 1);
        }
        return this.container;
    }

    public WrappedBlockFluidContainer getFluidContainer(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        if (this.fluidContainer == null) {
            this.fluidContainer = new WrappedBlockFluidContainer((BlockEntity)this, (FluidContainer)new InsertOnlyFluidContainer(ignored -> FluidConstants.toMillibuckets((long)4000L), 1, (slot, holder) -> true));
        }
        return direction == Direction.UP || direction == null ? this.fluidContainer : null;
    }

    public WrappedBlockFluidContainer getFluidContainer() {
        return this.getFluidContainer(this.f_58857_, this.f_58858_, this.m_58900_(), (BlockEntity)this, Direction.UP);
    }

    public Level getManaReceiverLevel() {
        return this.f_58857_;
    }

    public BlockPos getManaReceiverPos() {
        return this.m_58899_();
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public static int getMaxMana() {
        return 10000;
    }

    public boolean isFull() {
        return this.mana >= LiquidCrystallizerBlockEntity.getMaxMana();
    }

    public void receiveMana(int mana) {
        int old = this.mana;
        this.mana = Math.max(0, Math.min(this.getCurrentMana() + mana, LiquidCrystallizerBlockEntity.getMaxMana()));
        if (old != this.mana) {
            this.m_6596_();
            this.sendData();
        }
    }

    public boolean canReceiveManaFromBursts() {
        return true;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Mana", this.mana);
        compound.m_128405_("Timer", this.timer);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.mana = compound.m_128451_("Mana");
        this.timer = compound.m_128451_("Timer");
    }
}

