/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.rainshield.network.message;

import com.mrbysco.rainshield.util.RainShieldData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SyncShieldMapMessage {
    private final CompoundTag shieldMapTag;

    public SyncShieldMapMessage(CompoundTag tag) {
        this.shieldMapTag = tag;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.shieldMapTag);
    }

    public static SyncShieldMapMessage decode(FriendlyByteBuf buffer) {
        return new SyncShieldMapMessage(buffer.m_130260_());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isClient()) {
                UpdatePositions.update(this.shieldMapTag).run();
            }
        });
        ctx.setPacketHandled(true);
    }

    private static class UpdatePositions {
        private UpdatePositions() {
        }

        private static DistExecutor.SafeRunnable update(final CompoundTag shieldMapTag) {
            return new DistExecutor.SafeRunnable(){
                private static final long serialVersionUID = 1L;

                public void run() {
                    ListTag rainShieldMap = shieldMapTag.m_128437_("RainShieldMap", 10);
                    HashMap shieldMap = new HashMap();
                    for (int i = 0; i < rainShieldMap.size(); ++i) {
                        CompoundTag listTag = rainShieldMap.m_128728_(i);
                        String dimension = listTag.m_128461_("Dimension");
                        ResourceLocation dimensionLocation = ResourceLocation.m_135820_((String)dimension);
                        ArrayList<BlockPos> blockPositionsList = new ArrayList<BlockPos>();
                        ListTag blockPositions = listTag.m_128437_("BlockPositions", 10);
                        for (int j = 0; j < blockPositions.size(); ++j) {
                            CompoundTag blockPosTag = blockPositions.m_128728_(j);
                            BlockPos pos = BlockPos.m_122022_((long)blockPosTag.m_128454_("BlockPos"));
                            blockPositionsList.add(pos);
                        }
                        shieldMap.put(dimensionLocation, blockPositionsList);
                    }
                    RainShieldData.rainShieldMap.clear();
                    RainShieldData.rainShieldMap.putAll(shieldMap);
                }
            };
        }
    }
}

