/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.FlagAdvancementCondition;
import vazkii.quark.base.module.config.FlagLootCondition;
import vazkii.quark.base.module.config.FlagRecipeCondition;
import vazkii.quark.base.module.sync.SyncedFlagHandler;
import vazkii.quark.base.recipe.ingredient.FlagIngredient;
import vazkii.quark.base.recipe.ingredient.PotionIngredient;

public final class ConfigFlagManager {
    public static LootItemConditionType flagLootConditionType;
    private final List<String> orderedFlags = new ArrayList<String>();
    private final Set<String> allFlags = new HashSet<String>();
    private final Map<String, Boolean> flags = new HashMap<String, Boolean>();
    private boolean registered = false;

    public void registerConfigBoundElements() {
        if (this.registered) {
            throw new RuntimeException("Can't register twice.");
        }
        this.registered = true;
        CraftingHelper.register((IConditionSerializer)new FlagRecipeCondition.Serializer(this, new ResourceLocation("quark", "flag")));
        CraftingHelper.register((IConditionSerializer)new FlagAdvancementCondition.Serializer(this, new ResourceLocation("quark", "advancement_flag")));
        flagLootConditionType = new LootItemConditionType((Serializer)new FlagLootCondition.FlagSerializer(this));
        Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)new ResourceLocation("quark", "flag"), (Object)flagLootConditionType);
        CraftingHelper.register((ResourceLocation)new ResourceLocation("quark", "potion"), (IIngredientSerializer)PotionIngredient.Serializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)new ResourceLocation("quark", "flag"), (IIngredientSerializer)new FlagIngredient.Serializer(this));
        SyncedFlagHandler.setupFlagManager(this, this.orderedFlags);
    }

    public void clear() {
        this.flags.clear();
    }

    public void putFlag(QuarkModule module, String flag, boolean value) {
        this.flags.put(flag, value && module.enabled);
        if (!this.allFlags.contains(flag)) {
            this.orderedFlags.add(flag);
            this.allFlags.add(flag);
        }
    }

    public void putEnabledFlag(QuarkModule module) {
        this.putFlag(module, module.lowercaseName, true);
    }

    public boolean isValidFlag(String flag) {
        return this.flags.containsKey(flag);
    }

    public boolean getFlag(String flag) {
        Boolean obj = this.flags.get(flag);
        return obj != null && obj != false;
    }
}

