/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.network.message.structural;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.base.module.sync.SyncedFlagHandler;
import vazkii.quark.base.network.message.structural.C2SLoginFlag;
import vazkii.quark.base.network.message.structural.HandshakeMessage;

public class S2CLoginFlag
extends HandshakeMessage {
    public BitSet flags;
    public int expectedLength;
    public int expectedHash;

    public S2CLoginFlag() {
        this.flags = SyncedFlagHandler.compileFlagInfo();
        this.expectedLength = SyncedFlagHandler.expectedLength();
        this.expectedHash = SyncedFlagHandler.expectedHash();
    }

    public S2CLoginFlag(FriendlyByteBuf buf) {
        this.flags = BitSet.valueOf(buf.m_178381_());
        this.expectedLength = buf.readInt();
        this.expectedHash = buf.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130091_(this.flags.toLongArray());
        buf.writeInt(this.expectedLength);
        buf.writeInt(this.expectedHash);
    }

    public static List<Pair<String, S2CLoginFlag>> generateRegistryPackets(boolean isLocal) {
        return !isLocal ? Collections.singletonList(Pair.of((Object)S2CLoginFlag.class.getName(), (Object)new S2CLoginFlag())) : Collections.emptyList();
    }

    @Override
    public boolean consume(NetworkEvent.Context context, BiConsumer<HandshakeMessage, NetworkEvent.Context> reply) {
        if (this.expectedLength == SyncedFlagHandler.expectedLength() && this.expectedHash == SyncedFlagHandler.expectedHash()) {
            SyncedFlagHandler.receiveFlagInfoFromServer(this.flags);
        }
        reply.accept(new C2SLoginFlag(), context);
        return true;
    }
}

