/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.experimental.client.screen;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import vazkii.quark.content.experimental.module.VariantSelectorModule;

public class VariantSelectorScreen
extends Screen {
    private float timeIn = 0.0f;
    private int slotSelected = -1;
    private final Minecraft mc;
    private final ItemStack stack;
    private final KeyMapping key;
    private final String currentVariant;
    private final List<String> variants;
    private final List<DrawStack> drawStacks = new ArrayList<DrawStack>();

    public VariantSelectorScreen(ItemStack stack, KeyMapping key, String currentVariant, List<String> variants) {
        super((Component)Component.m_237119_());
        this.mc = Minecraft.m_91087_();
        this.stack = stack;
        this.key = key;
        this.currentVariant = currentVariant;
        this.variants = variants;
    }

    public void m_6305_(@Nonnull PoseStack ms, int mx, int my, float delta) {
        super.m_6305_(ms, mx, my, delta);
        this.timeIn += delta;
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        int maxRadius = 50;
        int segments = this.variants.size() + 1;
        float degPer = (float)Math.PI * 2 / (float)segments;
        float pad = -((float)Math.PI / (float)segments) + 1.5707964f;
        double angle = VariantSelectorScreen.mouseAngle(x, y, mx, my);
        double dist = (x - mx) * (x - mx) + (y - my) * (y - my);
        if (angle < (double)pad) {
            angle = Math.PI * 2 + (double)pad;
        }
        this.slotSelected = -1;
        Block block = Blocks.f_50652_;
        Item item = this.stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            block = bi.m_40614_();
        }
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buf = tess.m_85915_();
        RenderSystem.m_69464_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        this.drawStacks.clear();
        buf.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        for (int seg = 0; seg < segments; ++seg) {
            String variant = seg == 0 ? "" : this.variants.get(seg - 1);
            boolean rightVariant = variant.equals(this.currentVariant);
            Block variantBlock = VariantSelectorModule.getVariantForBlock(block, variant);
            boolean variantExists = seg == 0 || variantBlock != block;
            float start = (float)seg * degPer + pad;
            float end = (float)(seg + 1) * degPer + pad;
            boolean mouseInSector = variantExists && (double)start < angle && angle < (double)end && dist > 64.0;
            float radius = Math.max(0.0f, Math.min((this.timeIn - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
            if (mouseInSector || rightVariant) {
                radius *= 1.1f;
            }
            if (!variantExists) {
                radius *= 0.9f;
            }
            int gs = 57;
            if (seg % 2 == 0) {
                gs += 41;
            }
            int r = gs;
            int g = gs;
            int b = gs;
            int a = 68;
            if (variantExists) {
                g += 34;
                a = 153;
            } else {
                r /= 4;
                g /= 4;
                b /= 4;
            }
            if (seg == 0) {
                buf.m_5483_((double)x, (double)y, 0.0).m_6122_(r, g, b, a).m_5752_();
            }
            if (mouseInSector) {
                this.slotSelected = seg;
                r = 0;
                b = 170;
                g = 170;
            } else if (rightVariant) {
                b = 0;
                r = 0;
                g = 170;
            }
            float sxp = (float)x + Mth.m_14089_((float)start) * radius;
            float syp = (float)y + Mth.m_14031_((float)start) * radius;
            float exp = (float)x + Mth.m_14089_((float)end) * radius;
            float eyp = (float)y + Mth.m_14031_((float)end) * radius;
            buf.m_5483_((double)sxp, (double)syp, 0.0).m_6122_(r, g, b, a).m_5752_();
            buf.m_5483_((double)exp, (double)eyp, 0.0).m_6122_(r, g, b, a).m_5752_();
            float center = ((float)seg + 0.5f) * degPer + pad;
            float cxp = (float)x + Mth.m_14089_((float)center) * radius;
            float cyp = (float)y + Mth.m_14031_((float)center) * radius;
            ItemStack variantStack = variantExists ? new ItemStack((ItemLike)variantBlock) : ItemStack.f_41583_;
            double mod = 0.6;
            int xdp = (int)((double)(cxp - (float)x) * mod + (double)x);
            int ydp = (int)((double)(cyp - (float)y) * mod + (double)y);
            this.drawStacks.add(new DrawStack(variantStack, xdp - 8, ydp - 8));
        }
        tess.m_85914_();
        RenderSystem.m_69493_();
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
        for (DrawStack ds : this.drawStacks) {
            if (ds.stack().m_41619_()) continue;
            this.mc.m_91291_().m_115123_(ds.stack(), ds.x(), ds.y());
        }
        RenderSystem.m_69461_();
    }

    public void m_86600_() {
        super.m_86600_();
        if (!this.isKeyDown(this.key)) {
            this.mc.m_91152_(null);
            if (this.slotSelected == -1 && this.timeIn < 10.0f) {
                this.slotSelected = 0;
            }
            if (this.slotSelected != -1) {
                String variant = this.slotSelected == 0 ? "" : this.variants.get(this.slotSelected - 1);
                VariantSelectorModule.setClientVariant(variant, true);
                this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            }
        }
        ImmutableSet set = ImmutableSet.of((Object)this.mc.f_91066_.f_92085_, (Object)this.mc.f_91066_.f_92086_, (Object)this.mc.f_91066_.f_92087_, (Object)this.mc.f_91066_.f_92088_, (Object)this.mc.f_91066_.f_92090_, (Object)this.mc.f_91066_.f_92091_, (Object[])new KeyMapping[]{this.mc.f_91066_.f_92089_});
        for (KeyMapping k : set) {
            KeyMapping.m_90837_((InputConstants.Key)k.getKey(), (boolean)this.isKeyDown(k));
        }
    }

    public boolean isKeyDown(KeyMapping keybind) {
        InputConstants.Key key = keybind.getKey();
        if (key.m_84868_() == InputConstants.Type.MOUSE) {
            return keybind.m_90857_();
        }
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.m_84873_());
    }

    public boolean m_7043_() {
        return false;
    }

    private static double mouseAngle(int x, int y, int mx, int my) {
        return (Mth.m_14136_((double)(my - y), (double)(mx - x)) + Math.PI * 2) % (Math.PI * 2);
    }

    private record DrawStack(ItemStack stack, int x, int y) {
    }
}

