/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.recipe;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.quark.content.tweaks.module.SlabsToBlocksModule;

public class SlabToBlockRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<?> SERIALIZER = new SimpleRecipeSerializer(SlabToBlockRecipe::new);
    private boolean locked = false;

    public SlabToBlockRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer container, Level level) {
        if (this.locked) {
            return false;
        }
        Item target = null;
        boolean checked = false;
        boolean result = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (target != null) {
                if (checked) {
                    return false;
                }
                result = item == target && this.checkForOtherRecipes(container, level);
                checked = true;
                continue;
            }
            if (SlabsToBlocksModule.recipes.containsKey(item)) {
                target = item;
                continue;
            }
            return false;
        }
        return result;
    }

    private synchronized boolean checkForOtherRecipes(CraftingContainer container, Level level) {
        this.locked = true;
        boolean ret = false;
        MinecraftServer server = level.m_7654_();
        if (server != null) {
            Optional optional = server.m_129894_().m_44015_(RecipeType.f_44107_, (Container)container, level);
            ret = !optional.isPresent();
        }
        this.locked = false;
        return ret;
    }

    public ItemStack assemble(CraftingContainer container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            Item item;
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || !SlabsToBlocksModule.recipes.containsKey(item = stack.m_41720_())) continue;
            return new ItemStack((ItemLike)SlabsToBlocksModule.recipes.get(item));
        }
        return ItemStack.f_41583_;
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

