/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.undergroundstyle.base;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import vazkii.quark.base.world.generator.multichunk.ClusterBasedGenerator;
import vazkii.quark.content.world.undergroundstyle.base.UndergroundStyle;
import vazkii.quark.content.world.undergroundstyle.base.UndergroundStyleConfig;

public class UndergroundStyleGenerator<T extends UndergroundStyle>
extends ClusterBasedGenerator {
    public final UndergroundStyleConfig<T> info;

    public UndergroundStyleGenerator(UndergroundStyleConfig<T> info, String name) {
        super(info.dimensions, info, (long)name.hashCode());
        this.info = info;
    }

    @Override
    public int getFeatureRadius() {
        return this.info.horizontalSize + this.info.horizontalVariation;
    }

    @Override
    public BlockPos[] getSourcesInChunk(WorldGenRegion world, Random random, ChunkGenerator generator, BlockPos chunkCorner) {
        if (this.info.rarity > 0 && random.nextInt(this.info.rarity) == 0) {
            return new BlockPos[]{chunkCorner.m_7918_(random.nextInt(16), this.info.minYLevel + random.nextInt(this.info.maxYLevel - this.info.minYLevel), random.nextInt(16))};
        }
        return new BlockPos[0];
    }

    @Override
    public ClusterBasedGenerator.IGenerationContext createContext(BlockPos src, ChunkGenerator generator, Random random, BlockPos chunkCorner, WorldGenRegion world) {
        return new Context(world, src, generator, random, this.info);
    }

    @Override
    public boolean isSourceValid(WorldGenRegion world, ChunkGenerator generator, BlockPos pos) {
        BlockPos check = new BlockPos(pos.m_123341_(), this.info.minYLevel, pos.m_123343_());
        Holder<Biome> biome = this.getBiome((LevelAccessor)world, check, true);
        return this.info.biomes.canSpawn(biome);
    }

    public String toString() {
        return "UndergroundBiomeGenerator[" + this.info.biomeObj + "]";
    }

    public static class Context
    implements ClusterBasedGenerator.IFinishableContext {
        public final WorldGenRegion world;
        public final BlockPos source;
        public final ChunkGenerator generator;
        public final Random random;
        public final UndergroundStyleConfig<?> info;
        public final List<BlockPos> floorList = new LinkedList<BlockPos>();
        public final List<BlockPos> ceilingList = new LinkedList<BlockPos>();
        public final List<BlockPos> insideList = new LinkedList<BlockPos>();
        public final Map<BlockPos, Direction> wallMap = new HashMap<BlockPos, Direction>();

        public Context(WorldGenRegion world, BlockPos source, ChunkGenerator generator, Random random, UndergroundStyleConfig<?> info) {
            this.world = world;
            this.source = source;
            this.generator = generator;
            this.random = random;
            this.info = info;
        }

        @Override
        public void consume(BlockPos pos, double noise) {
            ((UndergroundStyle)this.info.biomeObj).fill(this, pos);
        }

        @Override
        public void finish() {
            this.floorList.forEach(pos -> ((UndergroundStyle)this.info.biomeObj).finalFloorPass(this, (BlockPos)pos));
            this.ceilingList.forEach(pos -> ((UndergroundStyle)this.info.biomeObj).finalCeilingPass(this, (BlockPos)pos));
            this.wallMap.keySet().forEach(pos -> ((UndergroundStyle)this.info.biomeObj).finalWallPass(this, (BlockPos)pos));
            this.insideList.forEach(pos -> ((UndergroundStyle)this.info.biomeObj).finalInsidePass(this, (BlockPos)pos));
        }
    }
}

