/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.items;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.environmental.EnvModuleProvider;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalConfiguration;
import mcjty.rftoolsutility.modules.environmental.modules.BuffEModule;
import mcjty.rftoolsutility.modules.environmental.modules.EnvironmentModule;
import mcjty.rftoolsutility.modules.environmental.modules.NoTeleportEModule;
import mcjty.rftoolsutility.modules.environmental.modules.PeacefulEModule;
import mcjty.rftoolsutility.modules.environmental.modules.PotionEffectModule;
import mcjty.rftoolsutility.playerprops.PlayerBuff;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.Lazy;

public abstract class EnvironmentalControllerItem
extends Item
implements EnvModuleProvider,
ITooltipSettings {
    private final Lazy<TooltipBuilder> tooltipBuilder;

    private EnvironmentalControllerItem(Lazy<TooltipBuilder> tooltipBuilder) {
        super(RFToolsUtility.setup.defaultProperties().m_41487_(16));
        this.tooltipBuilder = tooltipBuilder;
    }

    public void m_7373_(@Nonnull ItemStack itemStack, Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), itemStack, list, flag);
    }

    private static InfoLine[] createInfoLines(InfoLine[] inner, ForgeConfigSpec.DoubleValue rfPerTick) {
        InfoLine[] lines = new InfoLine[1 + inner.length + 1];
        lines[0] = TooltipBuilder.header();
        System.arraycopy(inner, 0, lines, 1, inner.length);
        lines[lines.length - 1] = TooltipBuilder.parameter((String)"power", stack -> rfPerTick.get() + " RF/tick (per cubic block)");
        return lines;
    }

    public static EnvironmentalControllerItem create(final String name, final Supplier<? extends EnvironmentModule> supplier, ForgeConfigSpec.DoubleValue rfPerTick, InfoLine ... tooltips) {
        return new EnvironmentalControllerItem(() -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(EnvironmentalControllerItem.createInfoLines(tooltips, rfPerTick))){

            @Override
            public Supplier<? extends EnvironmentModule> getServerEnvironmentModule() {
                return supplier;
            }

            @Override
            public String getName() {
                return name;
            }
        };
    }

    public static EnvironmentalControllerItem createBlindnessModule() {
        return EnvironmentalControllerItem.create("Blindness", () -> PotionEffectModule.create("blindness", 0, PlayerBuff.BUFF_BLINDNESS, (Double)EnvironmentalConfiguration.BLINDNESS_RFPERTICK.get(), () -> (Boolean)EnvironmentalConfiguration.blindnessAvailable.get()), EnvironmentalConfiguration.BLINDNESS_RFPERTICK, TooltipBuilder.warning(stack -> (Boolean)EnvironmentalConfiguration.blindnessAvailable.get() == false));
    }

    public static EnvironmentalControllerItem createFeatherfallingModule() {
        return EnvironmentalControllerItem.create("Feather", () -> BuffEModule.create(PlayerBuff.BUFF_FEATHERFALLING, (Double)EnvironmentalConfiguration.FEATHERFALLING_RFPERTICK.get()), EnvironmentalConfiguration.FEATHERFALLING_RFPERTICK, TooltipBuilder.gold());
    }

    public static EnvironmentalControllerItem createFeatherfallingPlusModule() {
        return EnvironmentalControllerItem.create("Feather+", () -> BuffEModule.create(PlayerBuff.BUFF_FEATHERFALLINGPLUS, (Double)EnvironmentalConfiguration.FEATHERFALLINGPLUS_RFPERTICK.get()), EnvironmentalConfiguration.FEATHERFALLINGPLUS_RFPERTICK, TooltipBuilder.gold());
    }

    public static EnvironmentalControllerItem createFlightModule() {
        return EnvironmentalControllerItem.create("Flight", () -> BuffEModule.create(PlayerBuff.BUFF_FLIGHT, (Double)EnvironmentalConfiguration.FLIGHT_RFPERTICK.get()), EnvironmentalConfiguration.FLIGHT_RFPERTICK, new InfoLine[0]);
    }

    public static EnvironmentalControllerItem createGlowingModule() {
        return EnvironmentalControllerItem.create("Glowing", () -> PotionEffectModule.create("glowing", 0, PlayerBuff.BUFF_GLOWING, (Double)EnvironmentalConfiguration.GLOWING_RFPERTICK.get()), EnvironmentalConfiguration.GLOWING_RFPERTICK, new InfoLine[0]);
    }

    public static EnvironmentalControllerItem createHasteModule() {
        return EnvironmentalControllerItem.create("Haste", () -> PotionEffectModule.create("haste", 0, PlayerBuff.BUFF_HASTE, (Double)EnvironmentalConfiguration.HASTE_RFPERTICK.get()), EnvironmentalConfiguration.HASTE_RFPERTICK, new InfoLine[0]);
    }

    public static EnvironmentalControllerItem createHastePlusModule() {
        return EnvironmentalControllerItem.create("Haste+", () -> PotionEffectModule.create("haste", 2, PlayerBuff.BUFF_HASTEPLUS, (Double)EnvironmentalConfiguration.HASTEPLUS_RFPERTICK.get()), EnvironmentalConfiguration.HASTEPLUS_RFPERTICK, new InfoLine[0]);
    }

    public static EnvironmentalControllerItem createLuckModule() {
        return EnvironmentalControllerItem.create("Luck", () -> PotionEffectModule.create("luck", 0, PlayerBuff.BUFF_LUCK, (Double)EnvironmentalConfiguration.LUCK_RFPERTICK.get()), EnvironmentalConfiguration.LUCK_RFPERTICK, new InfoLine[0]);
    }

    public static EnvironmentalControllerItem createNightvisionModule() {
        return EnvironmentalControllerItem.create("Vision", () -> PotionEffectModule.create("night_vision", 0, PlayerBuff.BUFF_NIGHTVISION, (Double)EnvironmentalConfiguration.NIGHTVISION_RFPERTICK.get()), EnvironmentalConfiguration.NIGHTVISION_RFPERTICK, new InfoLine[0]);
    }

    public static EnvironmentalControllerItem createNoteleportModule() {
        return EnvironmentalControllerItem.create("NoTP", NoTeleportEModule::new, EnvironmentalConfiguration.NOTELEPORT_RFPERTICK, new InfoLine[0]);
    }

    public static EnvironmentalControllerItem createPeacefulModule() {
        return EnvironmentalControllerItem.create("Peace", PeacefulEModule::new, EnvironmentalConfiguration.PEACEFUL_RFPERTICK, new InfoLine[0]);
    }

    public static EnvironmentalControllerItem createPoisonModule() {
        return EnvironmentalControllerItem.create("Poison", () -> PotionEffectModule.create("poison", 1, PlayerBuff.BUFF_POISON, (Double)EnvironmentalConfiguration.POISON_RFPERTICK.get(), () -> (Boolean)EnvironmentalConfiguration.poisonAvailable.get()), EnvironmentalConfiguration.POISON_RFPERTICK, TooltipBuilder.warning(stack -> (Boolean)EnvironmentalConfiguration.poisonAvailable.get() == false));
    }

    public static EnvironmentalControllerItem createRegenerationModule() {
        return EnvironmentalControllerItem.create("Regen", () -> PotionEffectModule.create("regeneration", 0, PlayerBuff.BUFF_REGENERATION, (Double)EnvironmentalConfiguration.REGENERATION_RFPERTICK.get()), EnvironmentalConfiguration.REGENERATION_RFPERTICK, new InfoLine[0]);
    }

    public static EnvironmentalControllerItem createRegenerationPlusModule() {
        return EnvironmentalControllerItem.create("Regen+", () -> PotionEffectModule.create("regeneration", 2, PlayerBuff.BUFF_REGENERATIONPLUS, (Double)EnvironmentalConfiguration.REGENERATIONPLUS_RFPERTICK.get()), EnvironmentalConfiguration.REGENERATIONPLUS_RFPERTICK, new InfoLine[0]);
    }

    public static EnvironmentalControllerItem createSaturationModule() {
        return EnvironmentalControllerItem.create("Saturation", () -> PotionEffectModule.create("saturation", 0, PlayerBuff.BUFF_SATURATION, (Double)EnvironmentalConfiguration.SATURATION_RFPERTICK.get()), EnvironmentalConfiguration.SATURATION_RFPERTICK, new InfoLine[0]);
    }

    public static EnvironmentalControllerItem createSaturationPlusModule() {
        return EnvironmentalControllerItem.create("Saturation+", () -> PotionEffectModule.create("saturation", 2, PlayerBuff.BUFF_SATURATIONPLUS, (Double)EnvironmentalConfiguration.SATURATIONPLUS_RFPERTICK.get()), EnvironmentalConfiguration.SATURATIONPLUS_RFPERTICK, new InfoLine[0]);
    }

    public static EnvironmentalControllerItem createSlownessModule() {
        return EnvironmentalControllerItem.create("Slowness", () -> PotionEffectModule.create("slowness", 3, PlayerBuff.BUFF_SLOWNESS, (Double)EnvironmentalConfiguration.SLOWNESS_RFPERTICK.get(), () -> (Boolean)EnvironmentalConfiguration.slownessAvailable.get()), EnvironmentalConfiguration.SLOWNESS_RFPERTICK, TooltipBuilder.warning(stack -> (Boolean)EnvironmentalConfiguration.slownessAvailable.get() == false));
    }

    public static EnvironmentalControllerItem createSpeedModule() {
        return EnvironmentalControllerItem.create("Speed", () -> PotionEffectModule.create("speed", 0, PlayerBuff.BUFF_SPEED, (Double)EnvironmentalConfiguration.SPEED_RFPERTICK.get()), EnvironmentalConfiguration.SPEED_RFPERTICK, new InfoLine[0]);
    }

    public static EnvironmentalControllerItem createSpeedPlusModule() {
        return EnvironmentalControllerItem.create("Speed+", () -> PotionEffectModule.create("speed", 2, PlayerBuff.BUFF_SPEEDPLUS, (Double)EnvironmentalConfiguration.SPEEDPLUS_RFPERTICK.get()), EnvironmentalConfiguration.SPEEDPLUS_RFPERTICK, new InfoLine[0]);
    }

    public static EnvironmentalControllerItem createWaterbreathingModule() {
        return EnvironmentalControllerItem.create("Water", () -> PotionEffectModule.create("water_breathing", 0, PlayerBuff.BUFF_WATERBREATHING, (Double)EnvironmentalConfiguration.WATERBREATHING_RFPERTICK.get()), EnvironmentalConfiguration.WATERBREATHING_RFPERTICK, new InfoLine[0]);
    }

    public static EnvironmentalControllerItem createWeaknessModule() {
        return EnvironmentalControllerItem.create("Weakness", () -> PotionEffectModule.create("weakness", 1, PlayerBuff.BUFF_WEAKNESS, (Double)EnvironmentalConfiguration.WEAKNESS_RFPERTICK.get(), () -> (Boolean)EnvironmentalConfiguration.weaknessAvailable.get()), EnvironmentalConfiguration.WEAKNESS_RFPERTICK, TooltipBuilder.warning(stack -> (Boolean)EnvironmentalConfiguration.weaknessAvailable.get() == false));
    }
}

