/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.FormatStyle;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.ILevelRenderHelper;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ITextRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.TextAlign;
import mcjty.rftoolsbase.api.screens.data.IModuleDataContents;
import mcjty.rftoolsbase.tools.ScreenTextHelper;
import mcjty.rftoolsutility.modules.screen.modulesclient.helper.ScreenLevelHelper;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class FluidBarClientScreenModule
implements IClientScreenModule<IModuleDataContents> {
    private String line = "";
    private int color = 0xFFFFFF;
    protected ResourceKey<Level> dim = Level.f_46428_;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    private final ITextRenderHelper labelCache = new ScreenTextHelper();
    private final ILevelRenderHelper mbRenderer = new ScreenLevelHelper().gradient(-16742145, -16764109);

    public IClientScreenModule.TransformMode getTransformMode() {
        return IClientScreenModule.TransformMode.TEXT;
    }

    public int getHeight() {
        return 10;
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, IModuleRenderHelper renderHelper, Font fontRenderer, int currenty, IModuleDataContents screenData, ModuleRenderInfo renderInfo) {
        int xoffset;
        if (!this.line.isEmpty()) {
            this.labelCache.setup(this.line, 160, renderInfo);
            this.labelCache.renderText(matrixStack, buffer, 0, currenty, this.color, renderInfo);
            xoffset = 47;
        } else {
            xoffset = 7;
        }
        if (!BlockPosTools.INVALID.equals((Object)this.coordinate)) {
            this.mbRenderer.render(matrixStack, buffer, xoffset, currenty, screenData, renderInfo);
        } else {
            renderHelper.renderText(matrixStack, buffer, xoffset, currenty, -65536, renderInfo, "<invalid>");
        }
    }

    public void mouseClick(Level world, int x, int y, boolean clicked) {
    }

    public void setupFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.m_128461_("text");
            this.color = tagCompound.m_128441_("color") ? tagCompound.m_128451_("color") : 0xFFFFFF;
            int mbcolorNeg = 0xFFFFFF;
            int mbcolor = tagCompound.m_128441_("mbcolor") ? tagCompound.m_128451_("mbcolor") : 0xFFFFFF;
            this.mbRenderer.color(mbcolor, mbcolorNeg);
            if (tagCompound.m_128441_("align")) {
                String alignment = tagCompound.m_128461_("align");
                this.labelCache.align(TextAlign.get((String)alignment));
            } else {
                this.labelCache.align(TextAlign.ALIGN_LEFT);
            }
            boolean hidebar = tagCompound.m_128471_("hidebar");
            boolean hidetext = tagCompound.m_128471_("hidetext");
            boolean showdiff = tagCompound.m_128471_("showdiff");
            boolean showpct = tagCompound.m_128471_("showpct");
            this.mbRenderer.settings(hidebar, hidetext, showpct, showdiff);
            this.mbRenderer.format(FormatStyle.values()[tagCompound.m_128451_("format")]);
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
        }
    }

    protected void setupCoordinateFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        if (tagCompound.m_128441_("monitorx")) {
            this.dim = LevelTools.getId((String)tagCompound.m_128461_("monitordim"));
            if (Objects.equals(dim, this.dim)) {
                BlockPos c = new BlockPos(tagCompound.m_128451_("monitorx"), tagCompound.m_128451_("monitory"), tagCompound.m_128451_("monitorz"));
                int dx = Math.abs(c.m_123341_() - pos.m_123341_());
                int dy = Math.abs(c.m_123342_() - pos.m_123342_());
                int dz = Math.abs(c.m_123343_() - pos.m_123343_());
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    public boolean needsServerData() {
        return true;
    }
}

