/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;

public class JsonHelper {
    public static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
        NonNullList ingredients = NonNullList.m_122779_();
        for (int i = 0; i < ingredientArray.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }

    public static List<Potion> readPotionList(JsonArray resultArray) {
        ArrayList<Potion> results = new ArrayList<Potion>();
        for (JsonElement result : resultArray) {
            String id = GsonHelper.m_13906_((JsonObject)result.getAsJsonObject(), (String)"id");
            results.add(JsonHelper.getPotion(new ResourceLocation(id)));
        }
        return results;
    }

    public static Potion getPotion(ResourceLocation potionName) {
        Optional potion = Registry.f_122828_.m_6612_(potionName);
        if (potion.isEmpty()) {
            throw new JsonSyntaxException("Unknown potion '" + potionName + "'");
        }
        return (Potion)potion.get();
    }

    public static MobEffect getEffect(ResourceLocation effectName) {
        Optional effect = Registry.f_122823_.m_6612_(effectName);
        if (effect.isEmpty()) {
            throw new JsonSyntaxException("Unknown effect '" + effectName + "'");
        }
        return (MobEffect)effect.get();
    }
}

