
let wasKeyDown = false

ClientEvents.tick(event => {
    if (Client.currentScreen?.class != 'class dev.ftb.mods.ftblibrary.ui.ScreenWrapper') return

    let screen = Client.currentScreen
    let gui = screen.getGui()
    let title
    let substitle
    let id

    let questPanel = gui?.questPanel
    if (!questPanel) return
    let widgets = questPanel?.widgets
    if (!widgets) return

    widgets.forEach(widget => {
        if (widget.isMouseOver()) {
            let questObject = widget.quest
            if (!questObject) return
            title = questObject.title ?? questObject.altTitle.siblings[0]?.string ?? "Or Filter - Needs Fixing"
            substitle = questObject.subtitle || ""
            id = questObject.toString()
        }
    })

    if (Client.isKeyDown(84) && Client.screen.hasShiftDown()) { //key 84 is 't'
        if (!wasKeyDown) {
            if (!id) return
            event.player.sendData('share_quest', { title: title, subtitle: substitle, id: id })
        }
        wasKeyDown = true
    } else {
        wasKeyDown = false
    }
})


