// priority: 0

const JEIhide = [
  "ae2:facade",
  "productivebees:configurable_honeycomb",
  "productivebees:configurable_comb",
  "cyclic:uncrafter",
  "cyclic:tile_transporter_empty",
  "cyclic:sleeping_mat",
  "cyclic:crafter",
  "create:steam_engine",
  "pneumaticcraft:plastic",
  "industrialforegoing:biofuel_bucket",
  "thermal:crude_oil_bucket",
  "thermal:device_tree_extractor",
  "thermal:latex_bucket",
  "thermal:creosote_bucket",
  "createastracompat:crushed_desh_ore",
  "thermal:coal_coke",
  "forcecraft:spoils_bag",
  "forcecraft:spoils_bag_t2",
  "forcecraft:spoils_bag_t3",
  "immersiveengineering:plantoil_bucket",
  "createaddition:tesla_coil",
  "redstone_arsenal:obsidian_rod",
  "thermal:light_oil_bucket", 
  "thermal:refined_fuel_bucket", 
  "thermal:heavy_oil_bucket",
];

const JEIhideFluids = [
  "industrialforegoing:biofuel",
  "thermal:crude_oil",
  "ad_astra:oil",
  "thermal:latex",
  "immersiveengineering:biodiesel",
  "createadditions:bioethanol",
  "immersiveengineering:ethanol",
  "mekanismgenerators:bioethanol",
  "immersiveengineering:plantoil",
  "createaddition:seed_oil",
  "thermal:creosote",
  "createaddition:biofuel",
  "pneumaticcraft:gasoline",
  "pneumaticcraft:lpg",
  "thermal:light_oil",
  "thermal:heavy_oil",
  "thermal:refined_fuel",
  "cofh_core:honey",
  "create:honey",
  "cyclic:honey",
];

JEIEvents.hideFluids((event) => {
  JEIhideFluids.forEach((id) => {
    console.log("Hiding fluid: " + id);
    event.hide(id);
  });
});

JEIEvents.hideItems((event) => {
  JEIhide.forEach((id) => {
    //   console.log('Hiding item: ' + id)
    event.hide(id);
  });

  JEIhideFluids.forEach((id) => {
    event.hide(Item.of("ceramicbucket:ceramic_bucket", `{Fluid:{Amount:1000,FluidName:"${id}"}}`));
  });

  global["hideOres"].forEach((hide) => {
    event.hide(hide);
  });

  global["unUnified"].forEach((unid) => {
    event.hide(unid);
  });

  global["circuitRemovals"].forEach((unid) => {
    event.hide(unid);
  });

  const apoth = [
    "botania:apothecary_forest",
    "botania:apothecary_plains",
    "botania:apothecary_mountain",
    "botania:apothecary_fu_desert",
    "botania:apothecaryngal",
    "botania:apothecary_swamp",
    "botania:apothecary_taiga",
    "botania:apothecary_mesa",
    "botania:apothecary_mossy",
    "botania:apothecary_livingrock",
    "botania:apothecary_deepslate",
  ];

  apoth.forEach((apo) => {
    // console.log('Hiding item: ' + apo)
    event.hide(apo);
  });

  event.hide(Item.of("gateways:gate_pearl").ignoreNBT());
});

JEIEvents.addItems((event) => {
  const reAddGateways = [
    Item.of("gateways:gate_pearl").withNBT('{gateway:"gateways:chicken_gate"}'),
    Item.of("gateways:gate_pearl").withNBT('{gateway:"gateways:endless_witch_gate"}'),
    Item.of("gateways:gate_pearl").withNBT('{gateway:"apotheosis:boss_gate_small"}'),
  ];
  reAddGateways.forEach((readd) => {
    event.add(readd);
  });
});

JEIEvents.removeCategories((event) => {
  //console.log(event.getCategoryIds())

  const removeCategories = [
    "create:draining",
    "botania:orechid",
    "botania:orechid_ignem",
    "occultism:miner",
    "industrialforegoing:laser_drill_ore",
    "create:automatic_shapeless",
    "create:automatic_shaped",
    "create:automatic_packaging",
    "create:automatic_packing",
    "industrialforegoing:bioreactor",
    "immersiveengineering:bottling_machine",
    "immersiveengineering:mixer",
    "elementalcraft:displacement",
    "elementalcraft:source_breeding",
    "industrialforegoing:fluid_sieving",
    "pneumaticcraft:amadron",
    "pneumaticcraft:spawner_extraction",
  ];

  removeCategories.forEach((catid) => {
    // console.log('Removing category id for: ' + catid)
    event.remove(catid);
  });
});
