
Ponder.registry((event) => {
    event.create('compactcrafting:field_projector').scene('field_projector', 'How to use the Field Projector.', 'ftbskies:mini_rocket_cone4', (scene, util) => {
        // global.rotate(scene, 180)
        const projectors = [
            [6, 12],
            [0, 6],
            [6, 0],
            [12, 6],
        ]
        const cannon = [
            [5, 1, 12],
            [4, 1, 12],
            [3, 1, 12],
        ]

        scene.world.setBlocks([4, 0, 4, 8, 0, 8], 'mekanismadditions:light_gray_plastic', false);
        scene.scaleSceneView(0.85)
        scene.showBasePlate();

        projectors.forEach(projector => {
            scene.idle(15)
            scene.world.showSection([projector[0], 1, projector[1]], Facing.DOWN);
            scene.world.showSection([projector[0], 2, projector[1]], Facing.DOWN);
            scene.world.showSection([projector[0], 3, projector[1]], Facing.DOWN);
            scene.idle(15)
            global.rotate(scene, 90)
        })
        scene.idle(25)
        scene.addKeyframe();
        scene.text(50, "First, place down your Field Projectors like this", [0, 2, 6]).placeNearTarget()
        scene.idle(45)
        scene.text(30, "You can use the Schematicanon to place down the Multiblocks", [4, 2, 12]).placeNearTarget();
        cannon.forEach(block => {
            scene.world.showSection(block, Facing.DOWN);
            scene.idle(2)
        })

        scene.idle(20)
        scene.text(30, "Or place them down manually", [4, 2, 4]).placeNearTarget();
        scene.idle(35)

        scene.addKeyframe()

        for (let y = 1; y < 6; y++) {
            for (let x = 3; x < 9; x++) {
                for (let z = 3; z < 9; z++) {
                    scene.world.showSection([x, y, z], Facing.UP);
                }
                scene.idle(2)
            }
        }
        scene.addKeyframe()
        scene.text(60, "If you used the Schematicanon...", [4, 1, 12]).placeNearTarget();
        scene.idle(45)
        scene.world.hideSection([4, 1, 5], Facing.WEST)
        scene.text(60, "Be sure to remove and replace 1 Block", [4, 2, 5]).placeNearTarget();
        scene.idle(45)
        scene.world.showSection([4, 1, 5], Facing.EAST)
        scene.addKeyframe()
        scene.idle(55)

        scene.text(60, "Also, be sure to remove all residual lights from the Feral Lanterns", [4, 1, 3]).placeNearTarget();
        scene.idle(55)

        scene.showControls(40, [2, 4, 9], "left").withItem("ftbskies:space_place")
        scene.text(40, "Toss the required Item", [2, 3, 9])
        scene.idle(25)
        let itemBlockPos = util.grid.at(2, 2, 9);
        let itemTop = util.vector.topOf(itemBlockPos);
        let item = scene.world.createItemEntity(itemTop, util.vector.of(0.3, 0.2, -0.3), 'ftbskies:space_plate');
        scene.idle(15)
        scene.world.removeEntity(item)

        scene.addKeyframe()
        global.rotate(scene, 360)
        scene.world.hideSection([3, 1, 3, 9, 6, 9], Facing.UP)
        scene.idle(25)
        itemBlockPos = util.grid.at(6, 1, 6);
        itemTop = util.vector.topOf(itemBlockPos);
        item = scene.world.createItemEntity(itemTop, util.vector.of(0, 0.6, 0), 'ad_astra:rocket_nose_cone')
        scene.idle(15)
        scene.text(60, "Enjoy your newly compacted Nose Cone!", [6, 2, 6]).placeNearTarget();

    })
})

global.rotate = (scene, degree) => {
    for (let i = 0; i <= degree; i++) {
        scene.rotateCameraY(1)
        if (i % 8 == 0) scene.idle(1)
    }
}