
Ponder.registry((event) => {
    event.create('cyclic:peat_farm').scene('peat_farm', 'How to use the Peat Farm.', 'ftbskies:peat_farm', (scene, util) => {

        scene.scaleSceneView(0.65)

        for (let x = 0; x < 18; x++) {
            for (let z = 0; z < 17; z++) {
                scene.world.showSection([x, 0, z], Facing.DOWN);

            }
        }
        scene.idle(5)

        scene.world.showSection([9, 1, 8], Facing.DOWN);

        scene.idle(5);
        scene.text(30, "First, place down your Peat Farm like this", [8, 2, 8]);
        scene.idle(31)
        scene.addKeyframe()

        scene.text(60, "The Peat Farm needs Water and FE", [8, 2, 8]);
        scene.idle(60)
        scene.world.showSection([11, 1, 7], Facing.DOWN);
        scene.idle(10)
        scene.world.showSection([11, 1, 9], Facing.DOWN);
        scene.idle(10)
        scene.world.showSection([11, 1, 8], Facing.DOWN);
        scene.idle(10)
        scene.world.showSection([10, 1, 8], Facing.DOWN);
        scene.idle(10)
        scene.world.showSection([9, 2, 8], Facing.DOWN);
        scene.addKeyframe()

        scene.text(60, "After that, give it Peat Bog and it will automaticly place it down", [8, 2, 8]);
        scene.idle(5)

        for (let i = 1; i < 17; i++) {
            scene.world.showSection([16, 1, i], Facing.DOWN);
            scene.world.showSection([15, 1, i], Facing.DOWN);
            scene.world.showSection([14, 1, i], Facing.DOWN);
            scene.idle(2);
        }
        for (let i = 13; i > 0; i--) {
            scene.world.showSection([i, 1, 15], Facing.DOWN);
            scene.world.showSection([i, 1, 14], Facing.DOWN);
            scene.world.showSection([i, 1, 13], Facing.DOWN);
            scene.idle(2);
        }
        for (let i = 13; i > 0; i--) {
            scene.world.showSection([2, 1, i], Facing.DOWN);
            scene.world.showSection([3, 1, i], Facing.DOWN);
            scene.world.showSection([4, 1, i], Facing.DOWN);
            scene.idle(2);
        }
        for (let i = 4; i < 15; i++) {
            scene.world.showSection([i, 1, 1], Facing.DOWN);
            scene.world.showSection([i, 1, 2], Facing.DOWN);
            scene.world.showSection([i, 1, 3], Facing.DOWN);
            scene.idle(2);
        }
        scene.addKeyframe()
        scene.text(30, "Saturated Peat will get harvested, but not automaticly picked up!", [8, 2, 8]);
        scene.idle(31)
        let saturatedBlocks = [
            [16, 1, 1], [16, 1, 3], [15, 1, 3], [14, 1, 1], [7, 1, 2], [14, 1, 3], [2, 1, 3], [3, 1, 1], [5, 1, 2], [4, 1, 3],
            [16, 1, 3], [7, 1, 15], [14, 1, 14], [2, 1, 14], [3, 1, 16], [4, 1, 14]
        ]
        saturatedBlocks.forEach(i => {
            scene.world.setBlock(i, 'cyclic:peat_baked', false)
            scene.idle(2)
        });
        let items = []
        saturatedBlocks.forEach(i => {

            let itemBlockPos = util.grid.at(i[0], i[1], i[2]);
            let itemTop = util.vector.topOf(itemBlockPos);
            let item = scene.world.createItemEntity(itemTop, util.vector.of(0, 0, 0), 'cyclic:peat_baked');

            items.push(item);
            scene.world.setBlock(i, 'cyclic:peat_unbaked', false)

            scene.idle(2);
        })




        scene.addKeyframe()
        scene.world.showSection([0, 1, 8], Facing.DOWN);
        scene.text(60, "For this, we can use various methods to pick it up", [8, 2, 15]);
        scene.idle(30)
        scene.text(60, "Like the Cyclic Item Collector", [0, 2, 9]);

        scene.idle(60)
        scene.text(60, "The Item Collector will easily collect up all items dropped inside a large area", [0, 1, 0]);
        items.forEach(i => {
            scene.world.removeEntity(i)
            scene.idle(2);
        });



    })
})