
Ponder.registry((event) => {
    event.create('spirit:soul_pedestal').scene('soul_pedestal', 'How to build the Summoning Area with Spirit.', 'ftbskies:spirit', (scene, util) => {


        for (let x = 0; x < 7; x++) {
            for (let z = 0; z < 7; z++) {
                scene.world.showSection([x, 0, z], Facing.DOWN);
            }
        }
        const pedestals = [
            { location: [3, 1, 0], item: "minecraft:coal" },
            { location: [1, 1, 1], item: "cyclic:peat_fuel_enriched" },
            { location: [5, 1, 1], item: "cyclic:peat_fuel_enriched" },
            { location: [0, 1, 3], item: "spirit:crude_soul_crystal" },
            { location: [6, 1, 3], item: "spirit:soul_powder" },
            { location: [1, 1, 5], item: "cyclic:peat_fuel_enriched" },
            { location: [5, 1, 5], item: "cyclic:peat_fuel_enriched" },
            { location: [3, 1, 6], item: "minecraft:coal" },
        ]

        const mainPedestal = [3, 1, 3]

        scene.idle(10)
        for (let z = 0; z < 7; z++) {
            for (let x = 0; x < 7; x++) {
                scene.world.showSection([x, 1, z], Facing.DOWN);
            }
            scene.idle(3);
        }
        scene.world.showSection([2, 3, 2], Facing.DOWN);
        scene.idle(5);
        scene.text(60, "Place your Summoning Altar like this!", [3, 2, 3]);
        scene.idle(65);
        scene.addLazyKeyframe()
        scene.text(40, "Place the Items on all the pedestals", [1, 1, 5])

        pedestals.forEach(pedestal => {
            const { location, item } = pedestal
            scene.world.modifyBlockEntityNBT(location, (nbt) => {
                console.log(item)
                nbt.item =
                {
                    Count: 1,
                    id: item,
                };
            });
            scene.idle(5)
        })
        scene.world.modifyBlockEntityNBT(mainPedestal, (nbt) => {
            nbt.Soul = "minecraft:chicken"
        });
        scene.idle(5)
        scene.showControls(30, [3, 2.5, 3], "down").withItem("spirit:soul_crystal_shard").rightClick()
        scene.text(60, "Place the Soul you want to summon on the main pedestal (Sadly Ponder cannot render Chickens for some reason)", [3, 2, 3]);
        scene.idle(65)
        scene.addKeyframe()
        scene.showControls(30, [3, 2.5, 3], "down").rightClick()
        scene.text(60, "Activate the Summoning Ritual by rightclicking the Pedestal with an empty hand", [3, 2, 3]);
        scene.idle(65)

        pedestals.forEach(pedestal => {
            const { location, item } = pedestal
            scene.world.modifyBlockEntityNBT(location, (nbt) => {
                nbt.item = {}
            });
        })
        let blazeBlockPos = util.grid.at(3, 1, 3);
        let blazeTop = util.vector.topOf(blazeBlockPos);
        let blaze = scene.world.createEntity("minecraft:blaze", blazeTop);
        scene.addKeyframe()
        scene.idle(25)
        scene.text(65, "Scoop up your freshly summoned Blaze, or fight it, your choice!", [3, 2, 3]);
        scene.idle(70)
        scene.world.removeEntity(blaze);

        const itemBlockPos = util.grid.at(3, 1, 3);
        const itemTop = util.vector.topOf(itemBlockPos);
        let item = scene.world.createItemEntity(itemTop, util.vector.of(0, 0, 0), "create:blaze_burner");
    })
})