﻿const toolTips = [
  ["forcecraft:force_shears", "Capable of shearing most animals!"],
  ["ftbskies:mycelium_spores", "Right click onto dirt to transform into mycelium"],
  ["ftbskies:warped_nylium_spores", "Right click onto netherrack to transform into warped nylium"],
  ["ftbskies:crimson_nylium_spores", "Right click onto netherrack to transform into crimson nylium"],
  ["ftbskies:eye_of_legend", "Moves in the direction of the nearest Sky Village"],
  ["cyclic:placer","Disabled due to claim protection bypassing."],
  ["ftbskies:eye_of_legend_end", "Moves in the direction of the nearest End City"],
  ["tropicraft:pineapple","Place and grow a pineapple to obtain multiple pineapple cubes."],
  ["thermal:blizz_powder", "Can be obtained by killing Blizzes, which you can summon with the Soul Pedestal. Check it's uses in JEI for the ritual recipe."],
  ["ftbskies:eye_of_legend_nether", "Moves in the direction of the nearest Nether Sky Village"],
  [
    "minecraft:end_portal_frame",
    "Shift-Right click with an empty hand to pickup\nCan only be placed on Glacio",
  ],
  ["ftbskies:mobfarm_deployer", "See JEI Information for useage"],
  ["supplementaries:ash", "Blast furnace only."],
  [
    "occultism:storage_controller",
    "WARNING: Breaking with large amount of items inside may potentially cause data loss or NBT overflow.",
  ],
  ["ars_nouveau:warp_scroll", "Tradeable from level 2 Lunarian Librarians"],
  ["minecraft:redstone", "First obtained by killing witches from an endless witch gateway."],
  [["minecraft:totem_of_undying"], "Can be traded from a level 2 Cleric Lunarian Trader on the Moon."],
  ["pneumaticcraft:pcb_blueprint", "Can be traded from an engineer (Charging Station Job)."],
  [["ftbskies_companion:liquid_crystallizer"], "Requires both Mana and Rotation to work."],
  [["quark:bottled_cloud"], "Can be made at a specific Y Level [192 to 195]."],
  [
    [
      "immersiveengineering:bucket_wheel",
      "immersiveengineering:diesel_generator",
      "immersiveengineering:excavator",
      "immersiveengineering:fermenter",
      "immersiveengineering:lightning_rod",
      "immersiveengineering:refinery",
      "immersiveengineering:squeezer",
      "immersiveengineering:mixer",
    ],
    "Disabled in this pack, will not form.",
  ],
  [
    "tropicraft:coconut_chunk",
    "Untainted from using a sword on a coconut. Coconut can's be obtained by growing a palm trees",
  ],
  ['mekanismgenerators:advanced_solar_generator', 'Does not produce FE, for thermal energy only.'],
  ['createteleporters:quantum_fluid_bucket', 'Too Unstable to be Bucketable. Use a Fluid Hopper to transfer it to a Tank.'],
  ['pedestals:upgrade_pedestal_attacker', 'Just like a Killer Joe, but on a Pedestal!'],
  ['spirit:soul_crystal', 'Needs the Tier 4 Soul Engulfing Setup!'],
  ['reaper:reaper_generator', 'Recipe requires a different Soul Engulfing Setup! Check JEI for more information.'],
  [
    [
      'mekanism:basic_smelting_factory', 
      'mekanism:basic_enriching_factory', 
      'mekanism:basic_crushing_factory', 
      'mekanism:basic_compressing_factory', 
      'mekanism:basic_combining_factory', 
      'mekanism:basic_purifying_factory', 
      'mekanism:basic_injecting_factory', 
      'mekanism:basic_infusing_factory', 
      'mekanism:basic_sawing_factory', 
      'mekanism:advanced_smelting_factory', 
      'mekanism:advanced_enriching_factory', 
      'mekanism:advanced_crushing_factory', 
      'mekanism:advanced_compressing_factory', 
      'mekanism:advanced_combining_factory', 
      'mekanism:advanced_purifying_factory', 
      'mekanism:advanced_injecting_factory', 
      'mekanism:advanced_infusing_factory', 
      'mekanism:advanced_sawing_factory', 
      'mekanism:elite_smelting_factory', 
      'mekanism:elite_enriching_factory', 
      'mekanism:elite_crushing_factory', 
      'mekanism:elite_compressing_factory', 
      'mekanism:elite_combining_factory', 
      'mekanism:elite_purifying_factory', 
      'mekanism:elite_injecting_factory', 
      'mekanism:elite_infusing_factory', 
      'mekanism:ultimate_enriching_factory', 
      'mekanism:ultimate_crushing_factory', 
      'mekanism:ultimate_compressing_factory', 
      'mekanism:ultimate_combining_factory', 
      'mekanism:ultimate_purifying_factory', 
      'mekanism:ultimate_injecting_factory', 
      'mekanism:ultimate_infusing_factory', 
      'mekanism:ultimate_sawing_factory'
    ],
    "⚠ Use Installers to obtain Factory Versions.",
  ],
  ["create:creative_blaze_cake", "⚠ Will be consumed when used! ⚠"],
  ["ftbskies:lightly_magical_imbued_soil", "ⓘ Provides a 25% Growth Boost in the Garden Cloche"],
  ["ftbskies:magical_imbued_soil", "ⓘ Provides a 50% Growth Boost in the Garden Cloche"],
  ["ftbskies:densely_magical_imbued_soil", "ⓘ Provides a 75% Growth Boost in the Garden Cloche"],
  ["create:water_wheel", "⚠ Produces Low amounts of Stress Units. ⚠"],
  ["create:windmill_bearing", "⚠ Produces Low amounts of Stress Units. ⚠"],
  ["thermal:raw_nickel", "ⓘ Can be Traded from Wandering Traders."],
  [
    [
      "minecraft:wither_rose",
      "minecraft:strider_spawn_egg",
      "nethersdelight:hoglin_hide",
      "create:blaze_cake",
      "productivebees:spawn_egg_nomad_bee",
      "nethersdelight:propelplant_cane",
      "wstweaks:fragment",
      "minecraft:amethyst_shard",
      "minecraft:ender_pearl",
      "tetra:thermal_cell",
      "minecraft:crying_obsidian",
      'forcecraft:force_log', 
      'cyclic:experience_food', 
      'minecraft:spectral_arrow', 
      'archers_paradox:shulker_arrow', 
      'minecraft:nether_brick', 
      'minecraft:music_disc_pigstep', 
      'minecraft:hoglin_spawn_egg', 
      'forcecraft:gold_chu_jelly', 
      'forcecraft:fortune_cookie', 
      'apotheosis:gem_dust', 
      Item.of('productivebees:spawn_egg_configurable_bee', '{EntityTag:{type:"productivebees:ghostly"}}'), 
      'minecraft:gilded_blackstone', 'cyclic:chorus_spectral', 
      Item.of('ceramicbucket:ceramic_bucket', '{Fluid:{Amount:1000,FluidName:"industrialforegoing:meat"}}')
    ],
    "ⓘ Can be Bartered from Piglins.",
  ],
  ["minecraft:blaze_rod", "ⓘ Can be bartered from Piglins or traded from Cleric Villagers."],
  ["easy_piglins:barterer", "ⓘ Search for 'Bartered' in JEI for a list of Valuable Outputs."],
];

ItemEvents.tooltip((e) => {
  let tooltipNBT = (itemNoNBT, itemWithNBT, theText) => {
    e.addAdvanced(itemNoNBT, (item, advanced, text) => {
      if (item.test(itemWithNBT)) {
        if (Array.isArray(theText)) {
          theText.forEach(function (line, index) {
            text.add(index + 1, line);
          });
        } else {
          text.add(1, theText);
        }
      }
    });
  };
  e.add(/ftbskies:.*deployer/, [
    Text.of("Right click to activate.").gray(),
    Text.of("Shift right click to lock or unlock Position").gray(),
    Text.of("Right click when locked to place Structure").gray(),
    Text.of("Left click to deactivate").gray(),
  ]);
  toolTips.forEach((tip) => e.add(tip[0], Text.gold(tip[1])));
});
