// ItemEvents.rightClicked('minecraft:stick',event => {
//     const {item,player,hand} = event
//     if (hand != "MAIN_HAND") return
//     if (!player) return
//     addCurioSlot(player, "ring", 100)
//     removeCurioSlot(player, "ring")

// })

const $CuriosApi = Java.loadClass("top.theillusivec4.curios.api.CuriosApi");
const $AttributeModifier = Java.loadClass("net.minecraft.world.entity.ai.attributes.AttributeModifier");
const $UUID = Java.loadClass("java.util.UUID");

/**
 * Adds a curio slot to the player.
 * @param {Player} player - The player to add the curio slot to.
 * @param {string} slot - The slot name.
 * @param {number} [amount=1] - The amount of the curio slot.
 * @param {string} [name=slot] - The name of the curio slot.
 */
function addCurioSlot(player, slot, amount, name) {
  if (amount == undefined) amount = 1;
  if (name == undefined) name = slot;
  let uuid = new $UUID.randomUUID();
  let curiosHandler = $CuriosApi.getCuriosHelper().getCuriosHandler(player);
  curiosHandler.ifPresent((handler) => {
    handler.getStacksHandler(slot).ifPresent((stacks) => {
      stacks.addPermanentModifier(new $AttributeModifier(uuid, name, amount, $AttributeModifier.Operation.ADDITION));
    });
  });
}
