const Player = Java.loadClass("net.minecraft.world.entity.player.Player")
const TimeUtil = Java.loadClass("net.minecraft.util.TimeUtil")
const $smallFireBall = Java.loadClass("net.minecraft.world.entity.projectile.SmallFireball")
const AvoidEntityGoal = Java.loadClass("net.minecraft.world.entity.ai.goal.AvoidEntityGoal")
const RandomStrollGoal = Java.loadClass("net.minecraft.world.entity.ai.goal.RandomStrollGoal")

/* 
* Custom Goals for the Venus Blaze
* In Order:
* 1. Look at the Player
* 2. Custom Attack Goal
* 3. Avoid Player
* 4. Random Look Around
* 5. Random Stroll
*/
EntityJSEvents.addGoalSelectors('ftbskies:venus_blaze', e => {
    let attackTime
    let attackStep
    let attackType = 0
    let lastSeen

    e.lookAtEntity(1, Player, 16, 1, false)
    e.customGoal(
        'do_custom_attack', // Name of the custom goal
        1,// Priority of the custom goal
        /** @param {Internal.PathfinderMob} mob **/mob => {
            // If the entity can use this goal
            return true
        },
        /** @param {Internal.PathfinderMob} mob **/mob => {
            // If the entity can continue using this goal
            return true
        },
        true, // Is goal interruptible
        /** @param {Internal.PathfinderMob} mob **/mob => { // Start function
            // Code ran at the start of the goal 
            attackTime = 0
            lastSeen = 0
        },
        /** @param {Internal.PathfinderMob} mob **/mob => { // Stop function
            mobgetNavigation().stop();
        },
        true, // Requires an update every tick?
        /** @param {Internal.PathfinderMob} mob **/mob => {
            attackTime--;

            const target = mob.getTarget()
            if(target == null) return
            
            let hasLineOfSight = mob.hasLineOfSight(target)
            if(hasLineOfSight){
                lastSeen = 0
            }else { lastSeen++}

            let d = mob.distanceToSqr(target)
            if(d < 4){
                if(!lastSeen) return
                if(attackTime <= 0){
                    attackTime = 50
                    mob.doHurtTarget(target)
                }
                mob.getMoveControl().setWantedPosition(target.x, target.y, target.z, 1.0)
            } else if ( d < 32*32 && hasLineOfSight){

        
                if(attackTime <= 0){
                
                    attackStep++
                    if(attackStep == 1){
                        attackType = mob.getRandom().nextInt(4)
                        attackTime = 40;
                    }else if (attackStep <= 3){
                        attackTime = 12;
                    } else {
                        attackTime = 80;
                        attackStep = 0
                    }
                }
                if (attackStep > 1){
                    // target.tell("Attacking with Attack Type: " + attackType)
                    switch(attackType){
                        case 0:{
                            attackTime = 80;
                            attackStep = 0;

                            mob.triggerAnimation('exampleController', 'hands');
                            global.attacks.magmaBlocks(mob, new Particle("minecraft:flame"))
                            break;
                        }
                        case 1:{
                            attackTime = 40;
                            attackStep = 0;
                            global.attacks.magicSlash(mob, new Particle("minecraft:witch"))
                            break;
                        }
                        default:
                            // Do Default attack
                            let x = target.x - mob.x
                            let y = target.y - mob.y
                            let z = target.z - mob.z
                            let h = JavaMath.sqrt(JavaMath.sqrt(d) * 0.5)

                            for(let i = 0; i <1;i++){

                                let smallFireBall = new $smallFireBall(mob.level, mob, mob.getRandom().triangle(x, 2.297 * h), y, mob.getRandom().triangle(z, 2.297 * h))
                                smallFireBall.setPos(smallFireBall.getX(), smallFireBall.getY(0.5)+1.5, smallFireBall.getZ())
                                mob.level.addFreshEntity(smallFireBall)
                                mob.playSound("minecraft:entity.blaze.shoot", 1.0 + mob.random.nextFloat(), mob.random.nextFloat() * 0.7 + 0.3)

                            }
                            break;
                        }
                }
                mob.getLookControl().setLookAt(target.x, target.y, target.z)
            } else if (lastSeen < 5){
                mob.getMoveControl().setWantedPosition(target.x, target.y, target.z, 1.0)
            }
        }
    )
    e.arbitraryGoal(3, entity => new AvoidEntityGoal(entity, Player, 3, 0.5, 0.4))
    e.randomLookAround(4)
    e.arbitraryGoal(5, entity => new RandomStrollGoal(entity, 0.5))
    
})
const $MoveTowardsTargetGoal = Java.loadClass("net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal")
EntityJSEvents.addGoals('ftbskies:venus_blaze', e => {
    e.nearestAttackableTarget(1, Player, 64, false, false, entity => {
        return true
    })

})

function Particle(type) {
	// Particle Attributes
	this.type = type ?? "minecraft:dust"
	this.color = 0xffffff
	this.endcolor = 0xffffff
	this.size = 1
	this.material = "minecraft:dirt"
	this.amount = 1
	this.hSpread = 0
	this.vSpread = 0
	this.speed = 0
	this.xOffset = 0
	this.zOffset = 0
	this.yOffset = 0

	// Casting Attributes
	this.delay = 0
	this.x = 0
	this.y = 0
	this.z = 0
	this.range = 0
	this.debug = false

	// Attacking Attributes
	this.attack = false  //attack default false, set to true, to hurt other entities
	this.attackDamage = 1
	this.attackRange = 2

	this.cast = function (caster) {
		this.x = caster.x + this.xOffset
		this.y = caster.y + this.yOffset
		this.z = caster.z + this.zOffset
		let dimension = caster.level.dimension
		switch (this.type) {
			case 'minecraft:dust': {
				this.type = this.type + " " + hexToNormalizedColor(this.color) + " " + this.size
				break
			}
			case 'minecraft:dust_color_transition': {
				this.type = this.type + " " + hexToNormalizedColor(this.color) + " " + this.size + " " + hexToNormalizedColor(this.endcolor)
				break
			}
			case 'minecraft:block':
			case 'minecraft:block_marker':
			case 'minecraft:falling_dust':
			case 'minecraft:item': {
				this.type = this.type + " " + this.material
				break
			}
		}

		let command = `execute in ${dimension} run particle ${this.type} ${this.x} ${this.y} ${this.z} ${this.hSpread} ${this.vSpread} ${this.hSpread} ${this.speed} ${this.amount} force`
		if (this.debug) console.log(command)
		Utils.server.runCommandSilent(command)

	}

}