const explosionSettings = {
  strength: 1,
  damagesTerrain: false,
  delay: 25,
  distance: 25,
};

ItemEvents.entityInteracted((event) => {
  const { server, target, level } = event;

  if (target.type != "energeticsheep:energetic_sheep") return;
  const { x, y, z } = target;

  server.scheduleInTicks(0, (callback) => {
    if (target.sheared) {
      let cmd = `execute in ${level.dimension} positioned ${x} ${y} ${z} run playsound minecraft:entity.creeper.primed neutral @p[distance=..${explosionSettings.distance}]`;
      console.log(cmd);
      server.runCommandSilent(cmd);
      server.scheduleInTicks(explosionSettings.delay, (callback2) => {
        let explosion = target.block.createExplosion();
        explosion.strength(explosionSettings.strength);
        explosion.damagesTerrain(explosionSettings.damagesTerrain);
        explosion.explode();
        target.kill();
      });
    }
  });
});
