// priority: 10000


const villageLoottables = [
  "minecraft:chests/village/village_cartographer",
  "minecraft:chests/village/village_temple",
  "minecraft:chests/village/village_toolsmith",
];

const elementalShards = {
  "air": ["ars_nouveau:wilden_stalker", "alexsmobs:guster"],
  "water": ["ars_nouveau:wilden_defender"],
  "fire": ["ars_nouveau:wilden_hunter", "mekanismadditions:baby_creeper"],
  "earth": ["mekanismadditions:baby_skeleton", "mekanismadditions:baby_stray", "mekanismadditions:baby_wither_skeleton"]
}

LootJS.modifiers((event) => {

  Object.entries(elementalShards).forEach(([element, mobs]) => {
    mobs.forEach(mob => {    
      event
        .addEntityLootModifier(mob)
        .addAlternativesLoot(
          LootEntry.of(`elementalcraft:powerful_${element}_shard`)
            .when((c) => c
              .randomChance(0.1)
              .killedByPlayer()
            ),
          LootEntry.of(`elementalcraft:${element}_shard`)
            .when((c) => c
              .randomChanceWithLooting(0.25, 0.1)),
        );
    })
  })

  event.addLootTableModifier(/skyvillages:chests\/nether\/sky_village_.*/)
    .pool(p => {
      p.rolls([1, 2])
      p.randomChance(0.5)
        .addWeightedLoot([
          LootEntry.of('ars_nouveau:red_archwood_sapling'),
          LootEntry.of('ars_nouveau:blue_archwood_sapling'),
          LootEntry.of('ars_nouveau:green_archwood_sapling'),
          LootEntry.of('ars_nouveau:purple_archwood_sapling'),
        ])
    })

  //apoth gems
    event
    .addLootTypeModifier(LootType.ENTITY)
    .addLoot(LootEntry.of("ftbskies:inert_gemstone").when((c) => c
    .randomChanceWithLooting(0.05, 0.01)
    .killedByPlayer()
    ))

  event
    .addEntityLootModifier("minecraft:witch")
    .addLoot(LootEntry.of("minecraft:redstone"));

  event.addEntityLootModifier("minecraft:sheep")
    .matchMainHand(Item.of("occultism:butcher_knife"))
    .randomChanceWithLooting(0.2, 0.2)
    .addLoot(LootEntry.of("occultism:tallow").limitCount([1, 2]));

  villageLoottables.forEach(lootTable => {
    event.addLootTableModifier(lootTable)
      .hasAnyStage("mana_steel_mesh")
      .randomChance(.75)
      .addLoot(LootEntry.of('botania:manasteel_ingot').limitCount([1, 4]))
  })


});
