const fluidToBucket = {
  "cyclic:biomass": "cyclic:biomass_bucket",
  "cyclic:slime": "cyclic:slime_bucket",
  "cyclic:xpjuice": "cyclic:xpjuice_bucket",
  "cyclic:honey": "cyclic:honey_bucket",
  "cyclic:magma": "cyclic:magma_bucket",
  "cyclic:wax": "cyclic:wax_bucket",
  "minecraft:water": "minecraft:water_bucket",
  "minecraft:lava": "minecraft:lava_bucket",
  "integrateddynamics:menril_resin": "integrateddynamics:bucket_menril_resin",
};

BlockEvents.rightClicked("cyclic:melting_chamber", (event) => {
  const { player, hand, item, block } = event;
  // player.tell(`You right clicked a ${block.id} with a ${item.id} in your ${hand}`)
  if (hand != "MAIN_HAND") return;
  if (item.id != "minecraft:bucket") return;

  if (!block.entityData) return;
  if (!block.entityData.fluid) return;
  let fluid = block.entityData.fluid.FluidName;
  if (!Object.keys(fluidToBucket).includes(fluid)) return;
  if (block.entityData.fluid.Amount < 1000) return;

  let newItem = fluidToBucket[fluid];
  let data = block.entityData;

  item.count--;

  data.fluid.Amount -= 1000;
  block.entityData = data;

  player.give(newItem);
  event.cancel();
});
